/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.reedelk.runtime.api.commons;

import de.codecentric.reedelk.runtime.api.commons.Preconditions;

public final class DefaultValues {
    private static final Double DOUBLE_DEFAULT = 0.0;
    private static final Float FLOAT_DEFAULT = Float.valueOf(0.0f);

    private DefaultValues() {
    }

    public static <T> Object defaultValue(Class<T> type) {
        Preconditions.checkArgument(type != null, "type");
        if (type == Boolean.TYPE) {
            return false;
        }
        if (type == Integer.TYPE) {
            return 0;
        }
        if (type == Long.TYPE) {
            return 0L;
        }
        if (type == Float.TYPE) {
            return FLOAT_DEFAULT;
        }
        if (type == Double.TYPE) {
            return DOUBLE_DEFAULT;
        }
        if (type == Short.TYPE) {
            return (short)0;
        }
        if (type == Byte.TYPE) {
            return (byte)0;
        }
        if (type == Character.TYPE) {
            return Character.valueOf('\u0000');
        }
        return null;
    }
}

