/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.reedelk.runtime.api.commons;

import de.codecentric.reedelk.runtime.api.commons.Preconditions;

public class ConfigurationPropertyUtils {
    public static boolean isConfigProperty(Object value) {
        return value instanceof String && ConfigurationPropertyUtils.isConfigProperty((String)value);
    }

    public static boolean isConfigProperty(String value) {
        if (value != null) {
            String trimmedValue = value.trim();
            return trimmedValue.startsWith("${") && value.endsWith("}");
        }
        return false;
    }

    public static String unwrap(String value) {
        return ConfigurationPropertyUtils.isConfigProperty(value) ? value.substring(2, value.length() - 1) : value;
    }

    public static String asConfigProperty(String label) {
        Preconditions.checkNotNull(label, "config property label");
        return "${" + label + "}";
    }
}

