/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.reedelk.runtime.api.commons;

import de.codecentric.reedelk.runtime.api.commons.DynamicValueUtils;
import de.codecentric.reedelk.runtime.api.commons.StringUtils;
import de.codecentric.reedelk.runtime.api.component.Implementor;
import de.codecentric.reedelk.runtime.api.exception.ComponentConfigurationException;
import de.codecentric.reedelk.runtime.api.exception.ComponentInputException;
import de.codecentric.reedelk.runtime.api.script.dynamicvalue.DynamicValue;

public class ComponentPrecondition {

    public static class Configuration {
        private Configuration() {
        }

        public static <T> T requireNotNull(Class<? extends Implementor> implementor, T object, String errorMessage) {
            if (object == null) {
                throw new ComponentConfigurationException(implementor, errorMessage);
            }
            return object;
        }

        public static String requireNotBlank(Class<? extends Implementor> implementor, String value, String errorMessage) {
            if (StringUtils.isBlank(value)) {
                throw new ComponentConfigurationException(implementor, errorMessage);
            }
            return value;
        }

        public static void requireTrue(Class<? extends Implementor> implementor, boolean expression, String errorMessage) {
            if (!expression) {
                throw new ComponentConfigurationException(implementor, errorMessage);
            }
        }

        public static <T extends DynamicValue<?>> T requireNotNullOrBlank(Class<? extends Implementor> implementor, T dynamicValue, String errorMessage) {
            if (!DynamicValueUtils.isNotNullOrBlank(dynamicValue)) {
                throw new ComponentConfigurationException(implementor, errorMessage);
            }
            return dynamicValue;
        }

        public static <T extends DynamicValue<?>> T requireNotNull(Class<? extends Implementor> implementor, T dynamicValue, String errorMessage) {
            if (dynamicValue == null) {
                throw new ComponentConfigurationException(implementor, errorMessage);
            }
            return dynamicValue;
        }
    }

    public static class Input {
        private Input() {
        }

        public static <T> T requireTypeMatches(Class<? extends Implementor> implementor, Object input, Class<T> expected) {
            if (input == null) {
                throw new ComponentInputException(implementor, input, expected);
            }
            if (expected.isAssignableFrom(input.getClass())) {
                return (T)input;
            }
            throw new ComponentInputException(implementor, input, expected);
        }

        public static <T> T requireTypeMatchesOrNull(Class<? extends Implementor> implementor, Object input, Class<T> expected) {
            if (input == null) {
                return null;
            }
            return Input.requireTypeMatches(implementor, input, expected);
        }

        public static void requireTypeMatchesAny(Class<? extends Implementor> implementor, Object input, Class<?> ... expected) {
            if (input == null) {
                throw new ComponentInputException(implementor, input, expected);
            }
            for (Class<?> current : expected) {
                if (!current.isAssignableFrom(input.getClass())) continue;
                return;
            }
            throw new ComponentInputException(implementor, input, expected);
        }

        public static void requireTypeMatchesAnyOrNull(Class<? extends Implementor> implementor, Object input, Class<?> ... expected) {
            if (input == null) {
                return;
            }
            Input.requireTypeMatchesAny(implementor, input, expected);
        }
    }
}

