/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.reedelk.runtime.api.commons;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class ByteArrayUtils {
    private static final int DEFAULT_BUFFER_SIZE = 16384;

    private ByteArrayUtils() {
    }

    public static byte[] from(InputStream input) throws IOException {
        return ByteArrayUtils.from(input, 16384);
    }

    public static byte[] from(InputStream input, int bufferSize) throws IOException {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[bufferSize];
        while ((nRead = input.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        return buffer.toByteArray();
    }
}

