package de.codecentric.reedelk.rabbitmq.internal.attribute;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Delivery;
import com.rabbitmq.client.Envelope;
import de.codecentric.reedelk.runtime.api.annotation.Type;
import de.codecentric.reedelk.runtime.api.annotation.TypeProperty;
import de.codecentric.reedelk.runtime.api.message.MessageAttributeKey;
import de.codecentric.reedelk.runtime.api.message.MessageAttributes;

import java.io.Serializable;
import java.util.HashMap;

import static de.codecentric.reedelk.rabbitmq.internal.attribute.RabbitMQConsumerAttributes.ENVELOPE;
import static de.codecentric.reedelk.rabbitmq.internal.attribute.RabbitMQConsumerAttributes.PROPERTIES;

@Type
@TypeProperty(name = PROPERTIES, type = PropertiesAttributes.class)
@TypeProperty(name = ENVELOPE, type = EnvelopeAttributes.class)
public class RabbitMQConsumerAttributes extends MessageAttributes {

    static final String PROPERTIES = "properties";
    static final String ENVELOPE = "envelope";

    public RabbitMQConsumerAttributes(Delivery delivery) {
        Envelope envelope = delivery.getEnvelope();
        HashMap<String, Serializable> envelopeAttrs = new EnvelopeAttributes(envelope);

        AMQP.BasicProperties properties = delivery.getProperties();
        HashMap<String, Serializable> propertiesAttrs = new PropertiesAttributes(properties);


        put(ENVELOPE, envelopeAttrs);
        put(PROPERTIES, propertiesAttrs);

        // We copy the AMQP correlationId to the Internal Correlation ID and we set it
        // as a Message Attribute with the given key: MessageAttributeKey.CORRELATION_ID.
        // This allows to access the correlation ID from the flow context using 'context.correlationId'
        // from a script or dynamic value.
        if (propertiesAttrs.containsKey(PropertiesAttributes.CORRELATION_ID)) {
            put(MessageAttributeKey.CORRELATION_ID,
                    propertiesAttrs.get(PropertiesAttributes.CORRELATION_ID));
        }
    }
}
