/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.reedelk.maven.plugin;

import de.codecentric.reedelk.module.descriptor.analyzer.ModuleDescriptorAnalyzer;
import de.codecentric.reedelk.module.descriptor.json.JsonProvider;
import de.codecentric.reedelk.module.descriptor.model.ModuleDescriptor;
import de.codecentric.reedelk.runtime.api.commons.StringUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="generate-module-descriptor", defaultPhase=LifecyclePhase.PROCESS_CLASSES)
public class ModuleDescriptorMavenMojo
extends AbstractMojo {
    @Parameter(property="project.build.outputDirectory")
    private String compiledClasses;
    @Parameter(property="project.build.resources[0].directory")
    private String resourcesDirectory;
    @Parameter(property="project.name")
    private String projectName;
    @Parameter(property="project.version")
    private String projectVersion;
    @Parameter(property="moduleName")
    private String moduleName;
    @Parameter(property="scanApi")
    private boolean scanApi;

    public void execute() throws MojoFailureException {
        ModuleDescriptorAnalyzer analyzer = new ModuleDescriptorAnalyzer();
        try {
            String finalModuleName;
            String string = finalModuleName = StringUtils.isBlank((CharSequence)this.moduleName) ? this.projectName : this.moduleName;
            if (this.scanApi) {
                List runtimeApiTypes = analyzer.scanRuntimeApiTypes();
                ModuleDescriptor moduleDescriptor = analyzer.fromDirectory(this.compiledClasses, finalModuleName, false);
                moduleDescriptor.setVersion(this.projectVersion);
                moduleDescriptor.getTypes().addAll(runtimeApiTypes);
                if (ModuleDescriptorMavenMojo.shouldWriteFile(moduleDescriptor)) {
                    this.writeAsJson(moduleDescriptor);
                }
            } else {
                ModuleDescriptor moduleDescriptor = analyzer.fromDirectory(this.compiledClasses, finalModuleName, false);
                moduleDescriptor.setVersion(this.projectVersion);
                if (ModuleDescriptorMavenMojo.shouldWriteFile(moduleDescriptor)) {
                    this.writeAsJson(moduleDescriptor);
                }
            }
        }
        catch (Exception error) {
            String errorMessage = String.format("Could not build components definitions: %s", error.getMessage());
            throw new MojoFailureException(errorMessage, (Throwable)error);
        }
    }

    private void writeAsJson(ModuleDescriptor moduleDescriptor) throws IOException {
        String resultJson = JsonProvider.toJson((ModuleDescriptor)moduleDescriptor);
        Path path = Paths.get(this.resourcesDirectory, "module-descriptor.json");
        byte[] strToBytes = resultJson.getBytes();
        Files.write(path, strToBytes, new OpenOption[0]);
        this.getLog().info((CharSequence)("Module Descriptor written on: " + path.toString()));
    }

    private static boolean shouldWriteFile(ModuleDescriptor descriptor) {
        return !descriptor.getComponents().isEmpty() || !descriptor.getTypes().isEmpty();
    }
}

