/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.reedelk.json.internal;

import de.codecentric.reedelk.runtime.api.commons.PlatformTypes;
import de.codecentric.reedelk.runtime.api.converter.ConverterService;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class ObjectToJSONConverter {
    private final ConverterService converterService;

    public ObjectToJSONConverter(ConverterService converterService) {
        this.converterService = converterService;
    }

    public Object toJSON(Object payload) {
        if (payload instanceof List) {
            return this.toJSON((List)payload);
        }
        if (payload instanceof Map) {
            return this.toJSON((Map)payload);
        }
        if (payload != null) {
            return PlatformTypes.isPrimitive(payload.getClass()) ? payload : new JSONObject(payload);
        }
        return null;
    }

    private JSONObject toJSON(Map<?, ?> map) {
        JSONObject object = new JSONObject(map);
        map.forEach((key, value) -> {
            String keyAsString = (String)this.converterService.convert(key, String.class);
            Object convertedValue = this.toJSON(value);
            object.put(keyAsString, convertedValue);
        });
        return object;
    }

    private JSONArray toJSON(List<?> list) {
        JSONArray array = new JSONArray(list);
        for (int i = 0; i < list.size(); ++i) {
            array.put(i, this.toJSON(list.get(i)));
        }
        return array;
    }
}

