/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.reedelk.json.internal;

import de.codecentric.reedelk.json.internal.commons.Messages;
import de.codecentric.reedelk.json.internal.exception.JSONToObjectException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class JSONToObjectConverter {
    public Object toObject(String payload) {
        Object token;
        try {
            token = new JSONTokener(payload).nextValue();
        }
        catch (JSONException exception) {
            String error = Messages.JSONToObject.JSON_PARSE_ERROR.format(new Object[]{exception.getMessage()});
            throw new JSONToObjectException(error, exception);
        }
        if (token instanceof JSONObject) {
            JSONObject object = (JSONObject)token;
            return object.toMap();
        }
        if (token instanceof JSONArray) {
            JSONArray array = (JSONArray)token;
            return array.toList();
        }
        String error = Messages.JSONToObject.JSON_TOKEN_ERROR.format(new Object[]{token});
        throw new JSONToObjectException(error);
    }
}

