/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.reedelk.json.component;

import de.codecentric.reedelk.json.component.JSONToObject;
import de.codecentric.reedelk.json.internal.ObjectToJSONConverter;
import de.codecentric.reedelk.json.internal.commons.IsValid;
import de.codecentric.reedelk.json.internal.commons.Messages;
import de.codecentric.reedelk.json.internal.exception.ObjectToJSONException;
import de.codecentric.reedelk.runtime.api.annotation.ComponentInput;
import de.codecentric.reedelk.runtime.api.annotation.ComponentOutput;
import de.codecentric.reedelk.runtime.api.annotation.DefaultValue;
import de.codecentric.reedelk.runtime.api.annotation.Description;
import de.codecentric.reedelk.runtime.api.annotation.Example;
import de.codecentric.reedelk.runtime.api.annotation.Hint;
import de.codecentric.reedelk.runtime.api.annotation.ModuleComponent;
import de.codecentric.reedelk.runtime.api.annotation.Property;
import de.codecentric.reedelk.runtime.api.annotation.When;
import de.codecentric.reedelk.runtime.api.component.ProcessorSync;
import de.codecentric.reedelk.runtime.api.converter.ConverterService;
import de.codecentric.reedelk.runtime.api.flow.FlowContext;
import de.codecentric.reedelk.runtime.api.message.Message;
import de.codecentric.reedelk.runtime.api.message.MessageAttributes;
import de.codecentric.reedelk.runtime.api.message.MessageBuilder;
import java.util.Optional;
import org.json.JSONArray;
import org.json.JSONObject;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@ModuleComponent(value="Object to JSON")
@ComponentOutput(attributes={MessageAttributes.class}, payload={String.class}, description="A JSON serialized string of the input Object.")
@ComponentInput(payload={Object.class}, description="An object structure to be converted to JSON string.")
@Description(value="Converts a Java Object into a JSON string. A Java List is mapped to a JSON Array and a Java Map is mapped to a Java Map. Any other Java object is mapped using getters. If pretty print is set to true, the output JSON is pretty printed using the given indent factor which adds a number of spaces to each level of indentation.")
@Component(service={ObjectToJSON.class}, scope=ServiceScope.PROTOTYPE)
public class ObjectToJSON
implements ProcessorSync {
    @Property(value="Pretty print")
    @Example(value="true")
    @DefaultValue(value="false")
    @Description(value="If true the output JSON is pretty printed using the given indent factor.")
    private Boolean prettyPrint;
    @Property(value="Indent")
    @Hint(value="4")
    @Example(value="2")
    @DefaultValue(value="2")
    @Description(value="The number of spaces to add to each level of indentation. If indent factor is 0 JSON object has only one key,  then the object will be output on a single line: <code>{ {\"key\": 1}}</code>")
    @When(propertyName="prettyPrint", propertyValue="true")
    private Integer indentFactor;
    @Reference
    ConverterService converterService;
    private int theIndentFactor;
    private boolean isPrettyPrint;
    private ObjectToJSONConverter converter;

    public void initialize() {
        this.isPrettyPrint = Optional.ofNullable(this.prettyPrint).orElse(false);
        this.theIndentFactor = Optional.ofNullable(this.indentFactor).orElse(2);
        this.converter = new ObjectToJSONConverter(this.converterService);
    }

    public Message apply(FlowContext flowContext, Message message) {
        Object payload = message.payload();
        if (payload == null) {
            return MessageBuilder.get(JSONToObject.class).empty().build();
        }
        if (payload instanceof String) {
            String input = (String)payload;
            if (IsValid.json(input)) {
                return MessageBuilder.get(JSONToObject.class).withJson(input).build();
            }
            throw new ObjectToJSONException(Messages.ObjectToJSON.NOT_JSON_STRING.format(new Object[0]));
        }
        Object result = this.converter.toJSON(payload);
        String json = this.print(result);
        return MessageBuilder.get(ObjectToJSON.class).withJson(json).build();
    }

    public void setPrettyPrint(Boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public void setIndentFactor(Integer indentFactor) {
        this.indentFactor = indentFactor;
    }

    private String print(Object result) {
        if (result instanceof JSONObject) {
            JSONObject outObject = (JSONObject)result;
            return this.isPrettyPrint ? outObject.toString(this.theIndentFactor) : outObject.toString();
        }
        if (result instanceof JSONArray) {
            JSONArray outArray = (JSONArray)result;
            return this.isPrettyPrint ? outArray.toString(this.theIndentFactor) : outArray.toString();
        }
        throw new ObjectToJSONException(Messages.ObjectToJSON.NOT_VALID_JSON_OBJECT.format(new Object[]{result == null ? null : result.getClass()}));
    }
}

