/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.reedelk.json.component;

import de.codecentric.reedelk.json.internal.JSONToObjectConverter;
import de.codecentric.reedelk.json.internal.commons.Preconditions;
import de.codecentric.reedelk.runtime.api.annotation.ComponentInput;
import de.codecentric.reedelk.runtime.api.annotation.ComponentOutput;
import de.codecentric.reedelk.runtime.api.annotation.Description;
import de.codecentric.reedelk.runtime.api.annotation.ModuleComponent;
import de.codecentric.reedelk.runtime.api.component.ProcessorSync;
import de.codecentric.reedelk.runtime.api.flow.FlowContext;
import de.codecentric.reedelk.runtime.api.message.Message;
import de.codecentric.reedelk.runtime.api.message.MessageAttributes;
import de.codecentric.reedelk.runtime.api.message.MessageBuilder;
import java.nio.charset.StandardCharsets;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ServiceScope;

@ModuleComponent(value="JSON to Object")
@ComponentOutput(attributes={MessageAttributes.class}, payload={Object.class}, description="An Object structure representing the given JSON string")
@ComponentInput(payload={String.class}, description="The JSON string to be converted to an Object structure.")
@Description(value="Converts a JSON string into a Java Object. A JSON object is mapped to a Java Map and a JSON array is mapped to a Java List. A null payload produces a null output payload and an exception is thrown if the input is not a String or a not valid JSON.")
@Component(service={JSONToObject.class}, scope=ServiceScope.PROTOTYPE)
public class JSONToObject
implements ProcessorSync {
    private JSONToObjectConverter converter;

    public void initialize() {
        this.converter = new JSONToObjectConverter();
    }

    public Message apply(FlowContext flowContext, Message message) {
        Object payload = message.payload();
        if (payload == null) {
            return MessageBuilder.get(JSONToObject.class).empty().build();
        }
        if (payload instanceof byte[] || payload instanceof Byte[]) {
            payload = this.convertAsStringUTF8((byte[])payload);
        }
        Preconditions.checkIsStringOrThrow(payload);
        Object asJavaObject = this.converter.toObject((String)payload);
        return MessageBuilder.get(JSONToObject.class).withJavaObject(asJavaObject).build();
    }

    @Deprecated
    private String convertAsStringUTF8(byte[] payload) {
        return new String(payload, StandardCharsets.UTF_8);
    }
}

