/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.reedelk.module.descriptor.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import de.codecentric.reedelk.module.descriptor.json.PropertyTypeDescriptorAttributes;
import de.codecentric.reedelk.module.descriptor.model.property.PropertyTypeDescriptor;
import de.codecentric.reedelk.module.descriptor.model.property.PropertyTypeDescriptorFactory;
import de.codecentric.reedelk.runtime.api.commons.PlatformTypes;
import java.lang.reflect.Type;

class PropertyTypeDescriptorDeserializer
implements JsonDeserializer<PropertyTypeDescriptor> {
    PropertyTypeDescriptorDeserializer() {
    }

    public PropertyTypeDescriptor deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext context) {
        if (!jsonElement.isJsonObject()) {
            throw new JsonParseException("Expected json object");
        }
        JsonObject myObject = jsonElement.getAsJsonObject();
        JsonElement typeDescriptorClassName = myObject.get(PropertyTypeDescriptorAttributes.CLASSNAME.value());
        Class<? extends PropertyTypeDescriptor> typeDescriptorClazz = PropertyTypeDescriptorFactory.from(typeDescriptorClassName.getAsString());
        JsonObject instanceObject = myObject.getAsJsonObject(PropertyTypeDescriptorAttributes.INSTANCE.value());
        PropertyTypeDescriptor deSerialized = (PropertyTypeDescriptor)context.deserialize((JsonElement)instanceObject, typeDescriptorClazz);
        JsonElement typeDescriptorClass = instanceObject.get(PropertyTypeDescriptorAttributes.TYPE.value());
        String clazzFullyQualifiedName = typeDescriptorClass.getAsString();
        if (Object.class.getName().equals(clazzFullyQualifiedName)) {
            deSerialized.setType(Object.class);
        } else if (byte[].class.getName().equals(clazzFullyQualifiedName)) {
            deSerialized.setType(byte[].class);
        } else {
            Class typeClazz = PlatformTypes.from((String)clazzFullyQualifiedName);
            deSerialized.setType(typeClazz);
        }
        return deSerialized;
    }
}

