/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.reedelk.module.descriptor.analyzer.type;

import de.codecentric.reedelk.module.descriptor.ModuleDescriptorException;
import de.codecentric.reedelk.module.descriptor.analyzer.commons.ScannerUtils;
import de.codecentric.reedelk.module.descriptor.model.type.TypePropertyDescriptor;
import de.codecentric.reedelk.runtime.api.annotation.TypeProperties;
import de.codecentric.reedelk.runtime.api.annotation.TypeProperty;
import de.codecentric.reedelk.runtime.api.annotation.UseDefaultType;
import io.github.classgraph.AnnotationInfo;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.FieldInfo;
import java.util.List;
import java.util.stream.Collectors;

public class TypePropertyAnalyzer {
    private final ClassInfo classInfo;

    public TypePropertyAnalyzer(ClassInfo classInfo) {
        this.classInfo = classInfo;
    }

    public List<TypePropertyDescriptor> analyze() {
        List<TypePropertyDescriptor> classLevelTypeProperties = this.classLevelTypeProperties();
        List<TypePropertyDescriptor> fieldLevelTypeProperties = this.fieldLevelTypeProperties();
        classLevelTypeProperties.addAll(fieldLevelTypeProperties);
        return classLevelTypeProperties;
    }

    private List<TypePropertyDescriptor> classLevelTypeProperties() {
        return ScannerUtils.repeatableAnnotation(this.classInfo, TypeProperty.class, TypeProperties.class).stream().map(annotationInfo -> {
            String name = ScannerUtils.parameterValueFrom(annotationInfo, "name", "###USE_DEFAULT_NAME###");
            String description = ScannerUtils.parameterValueFrom(annotationInfo, "description", "");
            String example = ScannerUtils.parameterValueFrom(annotationInfo, "example", "");
            if ("###USE_DEFAULT_NAME###".equals(name)) {
                String error = String.format("Name property must be defined for class level @TypeProperty annotations (class: %s).", this.classInfo.getName());
                throw new ModuleDescriptorException(error);
            }
            String type = this.getTypeFromOrThrowWhenDefault((AnnotationInfo)annotationInfo);
            TypePropertyDescriptor descriptor = new TypePropertyDescriptor();
            descriptor.setDescription(description);
            descriptor.setExample(example);
            descriptor.setName(name);
            descriptor.setType(type);
            return descriptor;
        }).collect(Collectors.toList());
    }

    private List<TypePropertyDescriptor> fieldLevelTypeProperties() {
        return this.classInfo.getDeclaredFieldInfo().filter(fieldInfo -> fieldInfo.hasAnnotation(TypeProperty.class.getName())).stream().map(fieldInfo -> {
            AnnotationInfo annotationInfo = fieldInfo.getAnnotationInfo(TypeProperty.class.getName());
            String name = ScannerUtils.parameterValueFrom(annotationInfo, "name", "###USE_DEFAULT_NAME###");
            String description = ScannerUtils.parameterValueFrom(annotationInfo, "description", "");
            String example = ScannerUtils.parameterValueFrom(annotationInfo, "example", "");
            String realName = "###USE_DEFAULT_NAME###".equals(name) ? fieldInfo.getName() : name;
            String fieldType = this.getTypeFrom(annotationInfo, (FieldInfo)fieldInfo);
            TypePropertyDescriptor descriptor = new TypePropertyDescriptor();
            descriptor.setDescription(description);
            descriptor.setExample(example);
            descriptor.setType(fieldType);
            descriptor.setName(realName);
            return descriptor;
        }).collect(Collectors.toList());
    }

    private String getTypeFromOrThrowWhenDefault(AnnotationInfo annotationInfo) {
        String type = ScannerUtils.parameterValueFrom(annotationInfo, "type", UseDefaultType.class.getName());
        if (UseDefaultType.class.getName().equals(type)) {
            throw new ModuleDescriptorException("Return type must be defined for class level @TypeProperty annotations.");
        }
        return type;
    }

    private String getTypeFrom(AnnotationInfo annotationInfo, FieldInfo fieldInfo) {
        String type = ScannerUtils.parameterValueFrom(annotationInfo, "type", UseDefaultType.class.getName());
        return UseDefaultType.class.getName().equals(type) ? fieldInfo.getTypeDescriptor().toString() : type;
    }
}

