/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.reedelk.module.descriptor.analyzer.type;

import de.codecentric.reedelk.module.descriptor.analyzer.commons.ScannerUtils;
import de.codecentric.reedelk.module.descriptor.analyzer.type.TypeFunctionAnalyzer;
import de.codecentric.reedelk.module.descriptor.analyzer.type.TypePropertyAnalyzer;
import de.codecentric.reedelk.module.descriptor.model.type.TypeDescriptor;
import de.codecentric.reedelk.module.descriptor.model.type.TypeFunctionDescriptor;
import de.codecentric.reedelk.module.descriptor.model.type.TypePropertyDescriptor;
import de.codecentric.reedelk.runtime.api.annotation.Type;
import de.codecentric.reedelk.runtime.api.annotation.UseDefaultType;
import de.codecentric.reedelk.runtime.api.commons.StringUtils;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.ScanResult;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class TypeAnalyzer {
    private final ScanResult scanResult;

    public TypeAnalyzer(ScanResult scanResult) {
        this.scanResult = scanResult;
    }

    public List<TypeDescriptor> analyze() {
        ClassInfoList types = this.scanResult.getClassesWithAnnotation(Type.class.getName());
        return types.stream().map(classInfo -> {
            boolean global = ScannerUtils.annotationParameterValueFrom(classInfo, Type.class, "global", Boolean.valueOf(false));
            String description = ScannerUtils.annotationParameterValueFrom(classInfo, Type.class, "description", "");
            String mapValueType = this.getMapValueType((ClassInfo)classInfo);
            String listItemType = this.getListItemType((ClassInfo)classInfo);
            String displayName = this.getDisplayName((ClassInfo)classInfo);
            String extendsType = this.superClassOf((ClassInfo)classInfo);
            String mapKeyType = this.getMapKeyType((ClassInfo)classInfo);
            TypeFunctionAnalyzer functionAnalyzer = new TypeFunctionAnalyzer((ClassInfo)classInfo);
            List<TypeFunctionDescriptor> functions = functionAnalyzer.analyze();
            TypePropertyAnalyzer propertyAnalyzer = new TypePropertyAnalyzer((ClassInfo)classInfo);
            List<TypePropertyDescriptor> properties = propertyAnalyzer.analyze();
            TypeDescriptor descriptor = new TypeDescriptor();
            descriptor.setListItemType(listItemType);
            descriptor.setType(classInfo.getName());
            descriptor.setExtendsType(extendsType);
            descriptor.setDisplayName(displayName);
            descriptor.setDescription(description);
            descriptor.setMapValueType(mapValueType);
            descriptor.setMapKeyType(mapKeyType);
            descriptor.setProperties(properties);
            descriptor.setFunctions(functions);
            descriptor.setGlobal(global);
            return descriptor;
        }).collect(Collectors.toList());
    }

    private String getDisplayName(ClassInfo classInfo) {
        String displayName = ScannerUtils.annotationParameterValueFrom(classInfo, Type.class, "displayName", "");
        return StringUtils.isNotBlank((CharSequence)displayName) ? displayName : null;
    }

    private String superClassOf(ClassInfo classInfo) {
        return classInfo.getSuperclass() != null ? classInfo.getSuperclass().getName() : null;
    }

    private String getListItemType(ClassInfo classInfo) {
        String listItemType = ScannerUtils.annotationParameterValueFrom(classInfo, Type.class, "listItemType", UseDefaultType.class.getName());
        if (UseDefaultType.class.getName().equals(listItemType)) {
            Class aClass = classInfo.loadClass();
            return List.class.isAssignableFrom(aClass) ? Object.class.getName() : null;
        }
        return listItemType;
    }

    private String getMapKeyType(ClassInfo classInfo) {
        String mapKeyType = ScannerUtils.annotationParameterValueFrom(classInfo, Type.class, "mapKeyType", UseDefaultType.class.getName());
        if (UseDefaultType.class.getName().equals(mapKeyType)) {
            Class aClass = classInfo.loadClass();
            return Map.class.isAssignableFrom(aClass) ? Object.class.getName() : null;
        }
        return mapKeyType;
    }

    private String getMapValueType(ClassInfo classInfo) {
        String mapValueType = ScannerUtils.annotationParameterValueFrom(classInfo, Type.class, "mapValueType", UseDefaultType.class.getName());
        if (UseDefaultType.class.getName().equals(mapValueType)) {
            Class aClass = classInfo.loadClass();
            return Map.class.isAssignableFrom(aClass) ? Object.class.getName() : null;
        }
        return mapValueType;
    }
}

