/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.reedelk.module.descriptor.analyzer.property.type;

import de.codecentric.reedelk.module.descriptor.analyzer.commons.ScannerUtils;
import de.codecentric.reedelk.module.descriptor.analyzer.component.ComponentAnalyzerContext;
import de.codecentric.reedelk.module.descriptor.analyzer.property.type.DescriptorFactory;
import de.codecentric.reedelk.module.descriptor.model.property.PropertyTypeDescriptor;
import de.codecentric.reedelk.module.descriptor.model.property.ResourceBinaryDescriptor;
import de.codecentric.reedelk.runtime.api.annotation.HintBrowseFile;
import de.codecentric.reedelk.runtime.api.annotation.WidthAuto;
import de.codecentric.reedelk.runtime.api.commons.PlatformTypes;
import io.github.classgraph.FieldInfo;

public class ResourceBinaryFactory
implements DescriptorFactory {
    @Override
    public boolean test(String fullyQualifiedClassName, FieldInfo fieldInfo, ComponentAnalyzerContext context) {
        return ScannerUtils.clazzByFullyQualifiedName(fullyQualifiedClassName).map(clazz -> PlatformTypes.isSupported((String)fullyQualifiedClassName) && ScannerUtils.isResourceBinary(clazz)).orElse(false);
    }

    @Override
    public PropertyTypeDescriptor create(String fullyQualifiedClassName, FieldInfo fieldInfo, ComponentAnalyzerContext context) {
        boolean widthAuto = ScannerUtils.hasAnnotation(fieldInfo, WidthAuto.class);
        String hintBrowseFile = ScannerUtils.annotationValueFrom(fieldInfo, HintBrowseFile.class, null);
        ResourceBinaryDescriptor descriptor = new ResourceBinaryDescriptor();
        descriptor.setHintBrowseFile(hintBrowseFile);
        if (widthAuto) {
            descriptor.setWidthAuto(Boolean.TRUE);
        }
        return descriptor;
    }
}

