/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.reedelk.module.descriptor.analyzer.property.type;

import de.codecentric.reedelk.module.descriptor.analyzer.commons.ScannerUtils;
import de.codecentric.reedelk.module.descriptor.analyzer.component.ComponentAnalyzerContext;
import de.codecentric.reedelk.module.descriptor.analyzer.property.type.DescriptorFactory;
import de.codecentric.reedelk.module.descriptor.model.property.ComboDescriptor;
import de.codecentric.reedelk.module.descriptor.model.property.PropertyTypeDescriptor;
import de.codecentric.reedelk.runtime.api.annotation.MimeTypeCombo;
import de.codecentric.reedelk.runtime.api.commons.PlatformTypes;
import de.codecentric.reedelk.runtime.api.commons.StringUtils;
import de.codecentric.reedelk.runtime.api.message.content.MimeType;
import io.github.classgraph.FieldInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class MimeTypeComboFactory
implements DescriptorFactory {
    @Override
    public boolean test(String fullyQualifiedClassName, FieldInfo fieldInfo, ComponentAnalyzerContext context) {
        return ScannerUtils.clazzByFullyQualifiedName(fullyQualifiedClassName).map(clazz -> PlatformTypes.isSupported((String)fullyQualifiedClassName) && ScannerUtils.isMimeTypeCombo(fieldInfo, clazz)).orElse(false);
    }

    @Override
    public PropertyTypeDescriptor create(String fullyQualifiedClassName, FieldInfo fieldInfo, ComponentAnalyzerContext context) {
        List<String> predefinedMimeTypes = MimeType.ALL.stream().map(MimeType::toString).collect(Collectors.toList());
        String additionalMimeTypes = ScannerUtils.annotationParameterValueFrom(fieldInfo, MimeTypeCombo.class, "additionalTypes", "");
        if (StringUtils.isNotBlank((CharSequence)additionalMimeTypes)) {
            String[] additionalTypes = additionalMimeTypes.split(",");
            predefinedMimeTypes = new ArrayList(predefinedMimeTypes);
            predefinedMimeTypes.addAll(Arrays.asList(additionalTypes));
        }
        String[] comboMimeTypesArray = predefinedMimeTypes.toArray(new String[0]);
        ComboDescriptor descriptor = new ComboDescriptor();
        descriptor.setEditable(true);
        descriptor.setComboValues(comboMimeTypesArray);
        descriptor.setPrototype("XXXXXXXXXXXXXXXXXXXXXXXXXX");
        return descriptor;
    }
}

