/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.reedelk.module.descriptor.analyzer.property.type;

import de.codecentric.reedelk.module.descriptor.analyzer.commons.ScannerUtils;
import de.codecentric.reedelk.module.descriptor.analyzer.component.ComponentAnalyzerContext;
import de.codecentric.reedelk.module.descriptor.analyzer.property.type.DescriptorFactory;
import de.codecentric.reedelk.module.descriptor.analyzer.property.type.DescriptorFactoryProvider;
import de.codecentric.reedelk.module.descriptor.model.property.MapDescriptor;
import de.codecentric.reedelk.module.descriptor.model.property.PropertyTypeDescriptor;
import de.codecentric.reedelk.runtime.api.annotation.DialogTitle;
import de.codecentric.reedelk.runtime.api.annotation.KeyName;
import de.codecentric.reedelk.runtime.api.annotation.TabGroup;
import de.codecentric.reedelk.runtime.api.annotation.ValueName;
import de.codecentric.reedelk.runtime.api.commons.PlatformTypes;
import io.github.classgraph.ClassRefTypeSignature;
import io.github.classgraph.FieldInfo;
import io.github.classgraph.TypeArgument;
import java.util.List;

public class MapFactory
implements DescriptorFactory {
    @Override
    public boolean test(String fullyQualifiedClassName, FieldInfo fieldInfo, ComponentAnalyzerContext context) {
        return ScannerUtils.clazzByFullyQualifiedName(fullyQualifiedClassName).map(clazz -> PlatformTypes.isSupported((String)fullyQualifiedClassName) && ScannerUtils.isMap(clazz)).orElse(false);
    }

    @Override
    public PropertyTypeDescriptor create(String fullyQualifiedClassName, FieldInfo fieldInfo, ComponentAnalyzerContext context) {
        String keyName = ScannerUtils.annotationValueFrom(fieldInfo, KeyName.class, null);
        String tabGroup = ScannerUtils.annotationValueFrom(fieldInfo, TabGroup.class, null);
        String valueName = ScannerUtils.annotationValueFrom(fieldInfo, ValueName.class, null);
        String dialogTitle = ScannerUtils.annotationValueFrom(fieldInfo, DialogTitle.class, null);
        ClassRefTypeSignature classRefTypeSignature = (ClassRefTypeSignature)fieldInfo.getTypeSignature();
        List typeArguments = classRefTypeSignature.getTypeArguments();
        TypeArgument typeArgument = (TypeArgument)typeArguments.get(1);
        String valueTypeFullyQualifiedName = typeArgument.toString();
        DescriptorFactory factory = DescriptorFactoryProvider.from(valueTypeFullyQualifiedName, fieldInfo, context);
        PropertyTypeDescriptor valueType = factory.create(valueTypeFullyQualifiedName, fieldInfo, context);
        MapDescriptor descriptor = new MapDescriptor();
        descriptor.setDialogTitle(dialogTitle);
        descriptor.setValueType(valueType);
        descriptor.setValueName(valueName);
        descriptor.setTabGroup(tabGroup);
        descriptor.setKeyName(keyName);
        return descriptor;
    }
}

