/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.reedelk.module.descriptor.analyzer.property;

import de.codecentric.reedelk.module.descriptor.analyzer.component.ComponentAnalyzerContext;
import de.codecentric.reedelk.module.descriptor.analyzer.property.DefaultValueAnalyzer;
import de.codecentric.reedelk.module.descriptor.analyzer.property.DescriptionAnalyzer;
import de.codecentric.reedelk.module.descriptor.analyzer.property.DisplayNameAnalyzer;
import de.codecentric.reedelk.module.descriptor.analyzer.property.ExampleAnalyzer;
import de.codecentric.reedelk.module.descriptor.analyzer.property.FieldInfoAnalyzer;
import de.codecentric.reedelk.module.descriptor.analyzer.property.GroupAnalyzer;
import de.codecentric.reedelk.module.descriptor.analyzer.property.HintAnalyzer;
import de.codecentric.reedelk.module.descriptor.analyzer.property.InitValueAnalyzer;
import de.codecentric.reedelk.module.descriptor.analyzer.property.MandatoryAnalyzer;
import de.codecentric.reedelk.module.descriptor.analyzer.property.NameAnalyzer;
import de.codecentric.reedelk.module.descriptor.analyzer.property.PropertyTypeAnalyzer;
import de.codecentric.reedelk.module.descriptor.analyzer.property.ScriptSignatureAnalyzer;
import de.codecentric.reedelk.module.descriptor.analyzer.property.WhenAnalyzer;
import de.codecentric.reedelk.module.descriptor.model.property.PropertyDescriptor;
import io.github.classgraph.FieldInfo;
import java.util.Arrays;
import java.util.List;

public class FieldInfoAnalyzers {
    private static final List<FieldInfoAnalyzer> FIELD_INFO_ANALYZERS = Arrays.asList(new NameAnalyzer(), new PropertyTypeAnalyzer(), new WhenAnalyzer(), new HintAnalyzer(), new GroupAnalyzer(), new ExampleAnalyzer(), new InitValueAnalyzer(), new MandatoryAnalyzer(), new DescriptionAnalyzer(), new DisplayNameAnalyzer(), new DefaultValueAnalyzer(), new ScriptSignatureAnalyzer());

    private FieldInfoAnalyzers() {
    }

    public static PropertyDescriptor analyze(FieldInfo fieldInfo, ComponentAnalyzerContext context) {
        PropertyDescriptor.Builder builder = PropertyDescriptor.builder();
        FIELD_INFO_ANALYZERS.forEach(handler -> handler.handle(fieldInfo, builder, context));
        return builder.build();
    }
}

