/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.reedelk.module.descriptor.analyzer.component;

import de.codecentric.reedelk.module.descriptor.model.component.ComponentType;
import de.codecentric.reedelk.runtime.api.component.AbstractInbound;
import de.codecentric.reedelk.runtime.api.component.Component;
import de.codecentric.reedelk.runtime.api.component.Inbound;
import de.codecentric.reedelk.runtime.api.component.Join;
import de.codecentric.reedelk.runtime.api.component.ProcessorAsync;
import de.codecentric.reedelk.runtime.api.component.ProcessorSync;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ClassInfoList;

class ComponentTypeAnalyzer {
    private final ClassInfo classInfo;

    ComponentTypeAnalyzer(ClassInfo classInfo) {
        this.classInfo = classInfo;
    }

    ComponentType analyze() {
        if (this.isInbound(this.classInfo)) {
            return ComponentType.INBOUND;
        }
        if (this.isProcessor(this.classInfo)) {
            return ComponentType.PROCESSOR;
        }
        if (this.isJoin(this.classInfo)) {
            return ComponentType.JOIN;
        }
        if (this.isComponent(this.classInfo)) {
            return ComponentType.COMPONENT;
        }
        return ComponentType.UNKNOWN;
    }

    private boolean isInbound(ClassInfo componentClassInfo) {
        ClassInfoList superclasses = componentClassInfo.getSuperclasses();
        boolean implementsAbstractInbound = superclasses.stream().anyMatch(superClassInfo -> superClassInfo.getName().equals(AbstractInbound.class.getName()));
        boolean implementsInboundInterface = componentClassInfo.getInterfaces().stream().anyMatch(interfaceClassInfo -> interfaceClassInfo.getName().equals(Inbound.class.getName()));
        return implementsAbstractInbound || implementsInboundInterface;
    }

    private boolean isProcessor(ClassInfo componentClassInfo) {
        return ComponentTypeAnalyzer.implementsInterface(componentClassInfo, ProcessorSync.class) || ComponentTypeAnalyzer.implementsInterface(componentClassInfo, ProcessorAsync.class);
    }

    private boolean isJoin(ClassInfo componentClassInfo) {
        return ComponentTypeAnalyzer.implementsInterface(componentClassInfo, Join.class);
    }

    private boolean isComponent(ClassInfo componentClassInfo) {
        return ComponentTypeAnalyzer.implementsInterface(componentClassInfo, Component.class);
    }

    private static boolean implementsInterface(ClassInfo componentClassInfo, Class target) {
        return componentClassInfo.getInterfaces().stream().anyMatch(classInfo -> classInfo.getName().equals(target.getName()));
    }
}

