/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.reedelk.module.descriptor.analyzer.commons;

import de.codecentric.reedelk.module.descriptor.ModuleDescriptorException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.Scanner;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class ReadModuleDescriptor {
    private ReadModuleDescriptor() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Optional<String> from(String jarFilePath) {
        try (JarFile file = new JarFile(jarFilePath);){
            String text;
            ZipEntry componentsConfigFile = file.getEntry("module-descriptor.json");
            if (componentsConfigFile == null) {
                Optional<String> optional = Optional.empty();
                return optional;
            }
            try (InputStream inputStream = file.getInputStream(componentsConfigFile);
                 Scanner scanner = new Scanner(inputStream, StandardCharsets.UTF_8.name());){
                text = scanner.useDelimiter("\\A").next();
            }
            Optional<String> optional = Optional.ofNullable(text);
            return optional;
        }
        catch (IOException e) {
            throw new ModuleDescriptorException("Components definition from Jar: " + jarFilePath, e);
        }
    }
}

