/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.reedelk.module.descriptor.model.property;

import de.codecentric.reedelk.module.descriptor.model.property.PropertyTypeDescriptor;
import de.codecentric.reedelk.module.descriptor.model.property.ScriptSignatureDescriptor;
import de.codecentric.reedelk.module.descriptor.model.property.WhenDescriptor;
import de.codecentric.reedelk.runtime.api.commons.Preconditions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class PropertyDescriptor
implements Serializable {
    private boolean mandatory;
    private String name;
    private String group;
    private String example;
    private String initValue;
    private String hintValue;
    private String description;
    private String displayName;
    private String defaultValue;
    private PropertyTypeDescriptor type;
    private ScriptSignatureDescriptor scriptSignature;
    private List<WhenDescriptor> whens;

    public boolean isMandatory() {
        return this.mandatory;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getExample() {
        return this.example;
    }

    public void setExample(String example) {
        this.example = example;
    }

    public String getInitValue() {
        return this.initValue;
    }

    public void setInitValue(String initValue) {
        this.initValue = initValue;
    }

    public String getHintValue() {
        return this.hintValue;
    }

    public void setHintValue(String hintValue) {
        this.hintValue = hintValue;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public <T extends PropertyTypeDescriptor> T getType() {
        return (T)this.type;
    }

    public void setType(PropertyTypeDescriptor type) {
        this.type = type;
    }

    public ScriptSignatureDescriptor getScriptSignature() {
        return this.scriptSignature;
    }

    public void setScriptSignature(ScriptSignatureDescriptor scriptSignature) {
        this.scriptSignature = scriptSignature;
    }

    public List<WhenDescriptor> getWhens() {
        return this.whens;
    }

    public void setWhens(List<WhenDescriptor> whens) {
        this.whens = whens;
    }

    public String toString() {
        return "PropertyDescriptor{name='" + this.name + '\'' + ", group='" + this.group + '\'' + ", example='" + this.example + '\'' + ", initValue='" + this.initValue + '\'' + ", hintValue='" + this.hintValue + '\'' + ", description='" + this.description + '\'' + ", displayName='" + this.displayName + '\'' + ", defaultValue='" + this.defaultValue + '\'' + ", type=" + this.type + ", scriptSignature=" + this.scriptSignature + ", whens=" + this.whens + '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private boolean mandatory;
        private String name;
        private String group;
        private String example;
        private String hintValue;
        private String initValue;
        private String description;
        private String displayName;
        private String defaultValue;
        private PropertyTypeDescriptor type;
        private ScriptSignatureDescriptor scriptSignature;
        private List<WhenDescriptor> whens = new ArrayList<WhenDescriptor>();

        public Builder mandatory() {
            this.mandatory = true;
            return this;
        }

        public Builder group(String group) {
            this.group = group;
            return this;
        }

        public Builder example(String example) {
            this.example = example;
            return this;
        }

        public Builder name(String propertyName) {
            this.name = propertyName;
            return this;
        }

        public Builder initValue(String initValue) {
            this.initValue = initValue;
            return this;
        }

        public Builder hintValue(String hintValue) {
            this.hintValue = hintValue;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder type(PropertyTypeDescriptor type) {
            this.type = type;
            return this;
        }

        public Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public Builder when(WhenDescriptor whenDescriptor) {
            this.whens.add(whenDescriptor);
            return this;
        }

        public Builder description(String propertyDescription) {
            this.description = propertyDescription;
            return this;
        }

        public Builder scriptSignature(ScriptSignatureDescriptor definition) {
            this.scriptSignature = definition;
            return this;
        }

        public PropertyDescriptor build() {
            Preconditions.checkState((this.name != null ? 1 : 0) != 0, (Object)"propertyName");
            Preconditions.checkState((this.type != null ? 1 : 0) != 0, (Object)"propertyType");
            PropertyDescriptor descriptor = new PropertyDescriptor();
            descriptor.name = this.name;
            descriptor.type = this.type;
            descriptor.group = this.group;
            descriptor.whens = this.whens;
            descriptor.example = this.example;
            descriptor.hintValue = this.hintValue;
            descriptor.initValue = this.initValue;
            descriptor.mandatory = this.mandatory;
            descriptor.description = this.description;
            descriptor.displayName = this.displayName;
            descriptor.defaultValue = this.defaultValue;
            descriptor.scriptSignature = this.scriptSignature;
            return descriptor;
        }
    }
}

