/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.reedelk.module.descriptor.model.component;

import de.codecentric.reedelk.module.descriptor.model.component.ComponentInputDescriptor;
import de.codecentric.reedelk.module.descriptor.model.component.ComponentOutputDescriptor;
import de.codecentric.reedelk.module.descriptor.model.component.ComponentType;
import de.codecentric.reedelk.module.descriptor.model.property.PropertyDescriptor;
import java.awt.Image;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.swing.Icon;

public class ComponentDescriptor
implements Serializable {
    private transient Icon icon;
    private transient Image image;
    private boolean hidden;
    private String displayName;
    private String description;
    private String fullyQualifiedName;
    private ComponentType type;
    private ComponentInputDescriptor input;
    private ComponentOutputDescriptor output;
    private List<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    public void setFullyQualifiedName(String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
    }

    public ComponentType getType() {
        return this.type;
    }

    public void setType(ComponentType type) {
        this.type = type;
    }

    public List<PropertyDescriptor> getProperties() {
        return this.properties;
    }

    public void setProperties(List<PropertyDescriptor> properties) {
        this.properties = properties;
    }

    public Optional<PropertyDescriptor> getPropertyDescriptor(String propertyName) {
        return this.properties.stream().filter(descriptor -> descriptor.getName().equals(propertyName)).findFirst();
    }

    public ComponentInputDescriptor getInput() {
        return this.input;
    }

    public void setInput(ComponentInputDescriptor input) {
        this.input = input;
    }

    public ComponentOutputDescriptor getOutput() {
        return this.output;
    }

    public void setOutput(ComponentOutputDescriptor output) {
        this.output = output;
    }

    public String toString() {
        return "ComponentDescriptor{hidden=" + this.hidden + ", displayName='" + this.displayName + '\'' + ", description='" + this.description + '\'' + ", fullyQualifiedName='" + this.fullyQualifiedName + '\'' + ", type=" + (Object)((Object)this.type) + ", input=" + this.input + ", output=" + this.output + ", properties=" + this.properties + '}';
    }

    public static Builder create() {
        return new Builder();
    }

    public static class Builder {
        private boolean hidden;
        private String displayName;
        private String description;
        private String fullyQualifiedName;
        private ComponentType type;
        private ComponentInputDescriptor input;
        private ComponentOutputDescriptor output;
        private List<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();

        public Builder properties(List<PropertyDescriptor> properties) {
            this.properties.addAll(properties);
            return this;
        }

        public Builder fullyQualifiedName(String fullyQualifiedName) {
            this.fullyQualifiedName = fullyQualifiedName;
            return this;
        }

        public Builder output(ComponentOutputDescriptor output) {
            this.output = output;
            return this;
        }

        public Builder input(ComponentInputDescriptor input) {
            this.input = input;
            return this;
        }

        public Builder type(ComponentType componentType) {
            this.type = componentType;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder hidden(boolean hidden) {
            this.hidden = hidden;
            return this;
        }

        public ComponentDescriptor build() {
            ComponentDescriptor descriptor = new ComponentDescriptor();
            descriptor.hidden = this.hidden;
            descriptor.displayName = this.displayName;
            descriptor.description = this.description;
            descriptor.fullyQualifiedName = this.fullyQualifiedName;
            descriptor.type = this.type;
            descriptor.input = this.input;
            descriptor.output = this.output;
            descriptor.properties.addAll(this.properties);
            return descriptor;
        }
    }
}

