/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.reedelk.module.descriptor.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import de.codecentric.reedelk.module.descriptor.ModuleDescriptorException;
import de.codecentric.reedelk.module.descriptor.analyzer.commons.Messages;
import de.codecentric.reedelk.module.descriptor.json.PropertyTypeDescriptorDeserializer;
import de.codecentric.reedelk.module.descriptor.json.PropertyTypeDescriptorSerializer;
import de.codecentric.reedelk.module.descriptor.model.ModuleDescriptor;
import de.codecentric.reedelk.module.descriptor.model.property.PropertyTypeDescriptor;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Scanner;
import org.apache.log4j.Logger;

public class JsonProvider {
    private static final Logger LOG = Logger.getLogger(JsonProvider.class);
    private static final Gson gson;

    private JsonProvider() {
    }

    public static String toJson(ModuleDescriptor moduleDescriptor) {
        try {
            return gson.toJson((Object)moduleDescriptor);
        }
        catch (Exception exception) {
            String error = Messages.JsonProvider.JSON_SERIALIZE_ERROR.format(new Object[]{exception.getMessage()});
            throw new ModuleDescriptorException(error, exception);
        }
    }

    public static ModuleDescriptor fromJson(String json) {
        try {
            return (ModuleDescriptor)gson.fromJson(json, ModuleDescriptor.class);
        }
        catch (Exception exception) {
            String error = Messages.JsonProvider.JSON_DESERIALIZE_ERROR.format(new Object[]{exception.getMessage()});
            throw new ModuleDescriptorException(error, exception);
        }
    }

    public static ModuleDescriptor fromURL(URL resource) {
        Scanner scanner = new Scanner(resource.openStream(), StandardCharsets.UTF_8.name());
        try {
            String json = scanner.useDelimiter("\\A").next();
            ModuleDescriptor moduleDescriptor = JsonProvider.fromJson(json);
            scanner.close();
            return moduleDescriptor;
        }
        catch (Throwable json) {
            try {
                try {
                    scanner.close();
                }
                catch (Throwable throwable) {
                    json.addSuppressed(throwable);
                }
                throw json;
            }
            catch (IOException exception) {
                String error = Messages.JsonProvider.JSON_DESERIALIZE_ERROR.format(new Object[]{exception.getMessage()});
                LOG.warn((Object)error, (Throwable)exception);
                return new ModuleDescriptor();
            }
        }
    }

    static {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(PropertyTypeDescriptor.class, (Object)new PropertyTypeDescriptorSerializer());
        gsonBuilder.registerTypeAdapter(PropertyTypeDescriptor.class, (Object)new PropertyTypeDescriptorDeserializer());
        gson = gsonBuilder.create();
    }
}

