/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.reedelk.module.descriptor.analyzer.type;

import de.codecentric.reedelk.module.descriptor.ModuleDescriptorException;
import de.codecentric.reedelk.module.descriptor.analyzer.commons.ScannerUtils;
import de.codecentric.reedelk.module.descriptor.model.type.TypeFunctionDescriptor;
import de.codecentric.reedelk.runtime.api.annotation.TypeFunction;
import de.codecentric.reedelk.runtime.api.annotation.TypeFunctions;
import de.codecentric.reedelk.runtime.api.annotation.UseDefaultType;
import io.github.classgraph.AnnotationInfo;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.MethodInfo;
import io.github.classgraph.MethodParameterInfo;
import io.github.classgraph.TypeSignature;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class TypeFunctionAnalyzer {
    private static final String AUTO_GENERATED_ARGUMENTS_PREFIX = "arg";
    private final ClassInfo classInfo;

    public TypeFunctionAnalyzer(ClassInfo classInfo) {
        this.classInfo = classInfo;
    }

    public List<TypeFunctionDescriptor> analyze() {
        List<TypeFunctionDescriptor> classLevelTypeFunctions = this.classLevelTypeFunctions();
        List<TypeFunctionDescriptor> methodLevelTypeFunctions = this.methodLevelTypeFunctions();
        classLevelTypeFunctions.addAll(methodLevelTypeFunctions);
        return classLevelTypeFunctions;
    }

    private List<TypeFunctionDescriptor> classLevelTypeFunctions() {
        return ScannerUtils.repeatableAnnotation(this.classInfo, TypeFunction.class, TypeFunctions.class).stream().map(annotationInfo -> {
            String signature = ScannerUtils.parameterValueFrom(annotationInfo, "signature", "###USE_DEFAULT_SIGNATURE###");
            String name = ScannerUtils.parameterValueFrom(annotationInfo, "name", "###USE_DEFAULT_NAME###");
            String description = ScannerUtils.parameterValueFrom(annotationInfo, "description", "");
            String example = ScannerUtils.parameterValueFrom(annotationInfo, "example", "");
            int cursorOffset = ScannerUtils.parameterValueFrom(annotationInfo, "cursorOffset", 0);
            if ("###USE_DEFAULT_NAME###".equals(name)) {
                String error = String.format("Name property must be defined for class level @TypeFunction annotation (class: %s).", this.classInfo.getName());
                throw new ModuleDescriptorException(error);
            }
            if ("###USE_DEFAULT_SIGNATURE###".equals(signature)) {
                String error = String.format("Signature property must be defined for class level @TypeFunction annotation (class: %s).", this.classInfo.getName());
                throw new ModuleDescriptorException(error);
            }
            String returnType = this.getReturnTypeFromOrThrowWhenDefault((AnnotationInfo)annotationInfo);
            TypeFunctionDescriptor descriptor = new TypeFunctionDescriptor();
            descriptor.setCursorOffset(cursorOffset);
            descriptor.setDescription(description);
            descriptor.setReturnType(returnType);
            descriptor.setSignature(signature);
            descriptor.setExample(example);
            descriptor.setName(name);
            return descriptor;
        }).collect(Collectors.toList());
    }

    private List<TypeFunctionDescriptor> methodLevelTypeFunctions() {
        return this.classInfo.getDeclaredMethodInfo().filter(methodInfo -> methodInfo.hasAnnotation(TypeFunction.class.getName())).stream().map(methodInfo -> {
            AnnotationInfo annotationInfo = methodInfo.getAnnotationInfo(TypeFunction.class.getName());
            String name = ScannerUtils.parameterValueFrom(annotationInfo, "name", "###USE_DEFAULT_NAME###");
            String description = ScannerUtils.parameterValueFrom(annotationInfo, "description", "");
            String example = ScannerUtils.parameterValueFrom(annotationInfo, "example", "");
            int cursorOffset = ScannerUtils.parameterValueFrom(annotationInfo, "cursorOffset", 0);
            String realName = "###USE_DEFAULT_NAME###".equals(name) ? methodInfo.getName() : name;
            String realSignature = this.getSignatureFrom(annotationInfo, (MethodInfo)methodInfo);
            String realReturnType = this.getReturnTypeFrom(annotationInfo, (MethodInfo)methodInfo);
            TypeFunctionDescriptor descriptor = new TypeFunctionDescriptor();
            descriptor.setReturnType(realReturnType);
            descriptor.setCursorOffset(cursorOffset);
            descriptor.setDescription(description);
            descriptor.setSignature(realSignature);
            descriptor.setExample(example);
            descriptor.setName(realName);
            return descriptor;
        }).collect(Collectors.toList());
    }

    private String getSignatureFrom(AnnotationInfo annotationInfo, MethodInfo methodInfo) {
        String signature = ScannerUtils.parameterValueFrom(annotationInfo, "signature", "###USE_DEFAULT_SIGNATURE###");
        if ("###USE_DEFAULT_SIGNATURE###".equals(signature)) {
            return this.createSignatureFrom(methodInfo);
        }
        return signature;
    }

    private String getReturnTypeFromOrThrowWhenDefault(AnnotationInfo annotationInfo) {
        String returnType = ScannerUtils.parameterValueFrom(annotationInfo, "returnType", UseDefaultType.class.getName());
        if (UseDefaultType.class.getName().equals(returnType)) {
            throw new ModuleDescriptorException("Return type must be defined for class level @TypeFunction annotations.");
        }
        return returnType;
    }

    private String getReturnTypeFrom(AnnotationInfo annotationInfo, MethodInfo methodInfo) {
        String returnType = ScannerUtils.parameterValueFrom(annotationInfo, "returnType", UseDefaultType.class.getName());
        if (UseDefaultType.class.getName().equals(returnType)) {
            TypeSignature resultType = methodInfo.getTypeDescriptor().getResultType();
            return resultType.toString();
        }
        return returnType;
    }

    private String createSignatureFrom(MethodInfo methodInfo) {
        StringBuilder signature = new StringBuilder(methodInfo.getName()).append("(");
        MethodParameterInfo[] parameterInfo = methodInfo.getParameterInfo();
        int argCount = 0;
        ArrayList<String> args = new ArrayList<String>();
        for (MethodParameterInfo info : parameterInfo) {
            String type = info.getTypeDescriptor().toStringWithSimpleNames();
            args.add(type + " " + AUTO_GENERATED_ARGUMENTS_PREFIX + argCount);
            ++argCount;
        }
        signature.append(String.join((CharSequence)", ", args));
        signature.append(")");
        return signature.toString();
    }
}

