/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.reedelk.module.descriptor.analyzer.property.type;

import de.codecentric.reedelk.module.descriptor.analyzer.commons.ScannerUtils;
import de.codecentric.reedelk.module.descriptor.analyzer.component.ComponentAnalyzerContext;
import de.codecentric.reedelk.module.descriptor.analyzer.component.UnsupportedType;
import de.codecentric.reedelk.module.descriptor.analyzer.property.PropertyAnalyzer;
import de.codecentric.reedelk.module.descriptor.analyzer.property.type.DescriptorFactory;
import de.codecentric.reedelk.module.descriptor.model.property.Collapsible;
import de.codecentric.reedelk.module.descriptor.model.property.ObjectDescriptor;
import de.codecentric.reedelk.module.descriptor.model.property.PropertyDescriptor;
import de.codecentric.reedelk.module.descriptor.model.property.PropertyTypeDescriptor;
import de.codecentric.reedelk.module.descriptor.model.property.Shared;
import de.codecentric.reedelk.runtime.api.annotation.DialogTitle;
import de.codecentric.reedelk.runtime.api.commons.PlatformTypes;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.FieldInfo;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class ObjectFactory
implements DescriptorFactory {
    @Override
    public boolean test(String fullyQualifiedClassName, FieldInfo fieldInfo, ComponentAnalyzerContext context) {
        return !PlatformTypes.isSupported((String)fullyQualifiedClassName);
    }

    @Override
    public PropertyTypeDescriptor create(String fullyQualifiedClassName, FieldInfo fieldInfo, ComponentAnalyzerContext context) {
        String dialogTitle = ScannerUtils.annotationValueFrom(fieldInfo, DialogTitle.class, null);
        ClassInfo classInfo = context.getClassInfo(fullyQualifiedClassName);
        if (classInfo == null) {
            throw new UnsupportedType(fullyQualifiedClassName);
        }
        Shared shared = ScannerUtils.isShareable(classInfo);
        Collapsible collapsible = ScannerUtils.isCollapsible(classInfo);
        PropertyAnalyzer propertyAnalyzer = new PropertyAnalyzer(context);
        List<PropertyDescriptor> allProperties = classInfo.getFieldInfo().stream().map(propertyAnalyzer::analyze).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        ObjectDescriptor descriptor = new ObjectDescriptor();
        descriptor.setTypeFullyQualifiedName(fullyQualifiedClassName);
        descriptor.setObjectProperties(allProperties);
        descriptor.setDialogTitle(dialogTitle);
        descriptor.setCollapsible(collapsible);
        descriptor.setShared(shared);
        return descriptor;
    }
}

