/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.reedelk.module.descriptor.analyzer.property.type;

import de.codecentric.reedelk.module.descriptor.analyzer.commons.ScannerUtils;
import de.codecentric.reedelk.module.descriptor.analyzer.component.ComponentAnalyzerContext;
import de.codecentric.reedelk.module.descriptor.analyzer.property.type.DescriptorFactory;
import de.codecentric.reedelk.module.descriptor.analyzer.property.type.DescriptorFactoryProvider;
import de.codecentric.reedelk.module.descriptor.model.property.ListDescriptor;
import de.codecentric.reedelk.module.descriptor.model.property.PropertyTypeDescriptor;
import de.codecentric.reedelk.runtime.api.annotation.DialogTitle;
import de.codecentric.reedelk.runtime.api.annotation.ListDisplayProperty;
import de.codecentric.reedelk.runtime.api.annotation.TabGroup;
import de.codecentric.reedelk.runtime.api.commons.PlatformTypes;
import io.github.classgraph.ClassRefTypeSignature;
import io.github.classgraph.FieldInfo;
import io.github.classgraph.TypeArgument;
import java.util.List;

public class ListFactory
implements DescriptorFactory {
    @Override
    public boolean test(String fullyQualifiedClassName, FieldInfo fieldInfo, ComponentAnalyzerContext context) {
        return ScannerUtils.clazzByFullyQualifiedName(fullyQualifiedClassName).map(clazz -> PlatformTypes.isSupported((String)fullyQualifiedClassName) && ScannerUtils.isList(clazz)).orElse(false);
    }

    @Override
    public PropertyTypeDescriptor create(String fullyQualifiedClassName, FieldInfo fieldInfo, ComponentAnalyzerContext context) {
        String tabGroup = ScannerUtils.annotationValueFrom(fieldInfo, TabGroup.class, null);
        String dialogTitle = ScannerUtils.annotationValueFrom(fieldInfo, DialogTitle.class, null);
        String listDisplayProperty = ScannerUtils.annotationValueFrom(fieldInfo, ListDisplayProperty.class, null);
        ClassRefTypeSignature classRefTypeSignature = (ClassRefTypeSignature)fieldInfo.getTypeSignature();
        List typeArguments = classRefTypeSignature.getTypeArguments();
        TypeArgument typeArgument = (TypeArgument)typeArguments.get(0);
        String valueTypeFullyQualifiedName = typeArgument.toString();
        DescriptorFactory factory = DescriptorFactoryProvider.from(valueTypeFullyQualifiedName, fieldInfo, context);
        PropertyTypeDescriptor valueType = factory.create(valueTypeFullyQualifiedName, fieldInfo, context);
        ListDescriptor descriptor = new ListDescriptor();
        descriptor.setListDisplayProperty(listDisplayProperty);
        descriptor.setDialogTitle(dialogTitle);
        descriptor.setValueType(valueType);
        descriptor.setTabGroup(tabGroup);
        return descriptor;
    }
}

