/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.reedelk.module.descriptor.analyzer.property.type;

import de.codecentric.reedelk.module.descriptor.analyzer.commons.ScannerUtils;
import de.codecentric.reedelk.module.descriptor.analyzer.component.ComponentAnalyzerContext;
import de.codecentric.reedelk.module.descriptor.analyzer.property.type.DescriptorFactory;
import de.codecentric.reedelk.module.descriptor.model.property.ComboDescriptor;
import de.codecentric.reedelk.module.descriptor.model.property.PropertyTypeDescriptor;
import de.codecentric.reedelk.runtime.api.annotation.Combo;
import de.codecentric.reedelk.runtime.api.commons.PlatformTypes;
import io.github.classgraph.FieldInfo;
import java.util.Arrays;

public class ComboFactory
implements DescriptorFactory {
    @Override
    public boolean test(String fullyQualifiedClassName, FieldInfo fieldInfo, ComponentAnalyzerContext context) {
        return ScannerUtils.clazzByFullyQualifiedName(fullyQualifiedClassName).map(clazz -> PlatformTypes.isSupported((String)fullyQualifiedClassName) && ScannerUtils.isCombo(fieldInfo, clazz)).orElse(false);
    }

    @Override
    public PropertyTypeDescriptor create(String fullyQualifiedClassName, FieldInfo fieldInfo, ComponentAnalyzerContext context) {
        boolean editable = ScannerUtils.annotationParameterValueFrom(fieldInfo, Combo.class, "editable", Boolean.valueOf(false));
        Object[] comboValues = ScannerUtils.annotationParameterValueFrom(fieldInfo, Combo.class, "comboValues", new String[0]);
        String prototype = ScannerUtils.annotationParameterValueFrom(fieldInfo, Combo.class, "prototype", null);
        String[] items = (String[])Arrays.stream(comboValues).map(value -> (String)value).toArray(String[]::new);
        ComboDescriptor descriptor = new ComboDescriptor();
        descriptor.setEditable(editable);
        descriptor.setComboValues(items);
        descriptor.setPrototype(prototype);
        return descriptor;
    }
}

