/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.reedelk.module.descriptor.analyzer.property;

import de.codecentric.reedelk.module.descriptor.analyzer.commons.ScannerUtils;
import de.codecentric.reedelk.module.descriptor.analyzer.component.ComponentAnalyzerContext;
import de.codecentric.reedelk.module.descriptor.analyzer.property.FieldInfoAnalyzer;
import de.codecentric.reedelk.module.descriptor.model.property.PropertyDescriptor;
import de.codecentric.reedelk.module.descriptor.model.property.WhenDescriptor;
import de.codecentric.reedelk.runtime.api.annotation.When;
import de.codecentric.reedelk.runtime.api.annotation.Whens;
import io.github.classgraph.AnnotationInfo;
import io.github.classgraph.FieldInfo;

public class WhenAnalyzer
implements FieldInfoAnalyzer {
    @Override
    public void handle(FieldInfo fieldInfo, PropertyDescriptor.Builder builder, ComponentAnalyzerContext context) {
        ScannerUtils.repeatableAnnotation(fieldInfo, When.class, Whens.class).forEach(annotationInfo -> {
            WhenDescriptor whenDescriptor = this.processWhenInfo((AnnotationInfo)annotationInfo);
            builder.when(whenDescriptor);
        });
    }

    private WhenDescriptor processWhenInfo(AnnotationInfo info) {
        String propertyName = ScannerUtils.parameterValueFrom(info, "propertyName", "");
        String propertyValue = ScannerUtils.parameterValueFrom(info, "propertyValue", "");
        WhenDescriptor definition = new WhenDescriptor();
        definition.setPropertyName(propertyName);
        definition.setPropertyValue(propertyValue);
        return definition;
    }
}

