/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.reedelk.module.descriptor.analyzer.component;

import de.codecentric.reedelk.module.descriptor.ModuleDescriptorException;
import de.codecentric.reedelk.module.descriptor.analyzer.commons.ScannerUtils;
import de.codecentric.reedelk.module.descriptor.model.component.ComponentOutputDescriptor;
import de.codecentric.reedelk.runtime.api.annotation.ComponentOutput;
import de.codecentric.reedelk.runtime.api.message.MessageAttributes;
import io.github.classgraph.AnnotationClassRef;
import io.github.classgraph.AnnotationInfo;
import io.github.classgraph.ClassInfo;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class ComponentOutputAnalyzer {
    private static final Object[] EMPTY = new Object[0];
    private static final List<String> DEFAULT_ATTRIBUTES = Collections.singletonList(MessageAttributes.class.getName());
    private final ClassInfo classInfo;

    public ComponentOutputAnalyzer(ClassInfo classInfo) {
        this.classInfo = classInfo;
    }

    public ComponentOutputDescriptor analyze() {
        if (!ScannerUtils.hasAnnotation(this.classInfo, ComponentOutput.class)) {
            return null;
        }
        AnnotationInfo annotationInfo = this.classInfo.getAnnotationInfo(ComponentOutput.class.getName());
        String description = ScannerUtils.parameterValueFrom(annotationInfo, "description", "");
        String dynamicPropertyName = ScannerUtils.parameterValueFrom(annotationInfo, "dynamicPropertyName", "");
        List<String> attributesType = this.getOutputAttributes(annotationInfo);
        List<String> outputPayload = this.getOutputPayload(annotationInfo);
        if (outputPayload.isEmpty()) {
            String error = String.format("Component Output payload types must not be empty (class: %s).", this.classInfo.getName());
            throw new ModuleDescriptorException(error);
        }
        ComponentOutputDescriptor descriptor = new ComponentOutputDescriptor();
        descriptor.setDynamicPropertyName(dynamicPropertyName);
        descriptor.setAttributes(attributesType);
        descriptor.setDescription(description);
        descriptor.setPayload(outputPayload);
        return descriptor;
    }

    private List<String> getOutputPayload(AnnotationInfo annotationInfo) {
        Object[] payload = ScannerUtils.parameterValueFrom(annotationInfo, "payload", EMPTY);
        return Arrays.stream(payload).map(annotationClassRef -> ((AnnotationClassRef)annotationClassRef).getName()).collect(Collectors.toList());
    }

    private List<String> getOutputAttributes(AnnotationInfo annotationInfo) {
        Object[] attributes = ScannerUtils.parameterValueFrom(annotationInfo, "attributes", EMPTY);
        return attributes.length == 0 ? DEFAULT_ATTRIBUTES : Arrays.stream(attributes).map(annotationClassRef -> ((AnnotationClassRef)annotationClassRef).getName()).collect(Collectors.toList());
    }
}

