/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.reedelk.module.descriptor.analyzer.component;

import de.codecentric.reedelk.module.descriptor.analyzer.commons.ScannerUtils;
import de.codecentric.reedelk.module.descriptor.model.component.ComponentInputDescriptor;
import de.codecentric.reedelk.runtime.api.annotation.ComponentInput;
import io.github.classgraph.AnnotationClassRef;
import io.github.classgraph.AnnotationInfo;
import io.github.classgraph.ClassInfo;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class ComponentInputAnalyzer {
    private final ClassInfo classInfo;
    private static final Object[] EMPTY = new Object[0];

    public ComponentInputAnalyzer(ClassInfo classInfo) {
        this.classInfo = classInfo;
    }

    public ComponentInputDescriptor analyze() {
        if (!ScannerUtils.hasAnnotation(this.classInfo, ComponentInput.class)) {
            return null;
        }
        AnnotationInfo annotationInfo = this.classInfo.getAnnotationInfo(ComponentInput.class.getName());
        List<String> inputPayload = this.getInputPayload(annotationInfo);
        String description = ScannerUtils.parameterValueFrom(annotationInfo, "description", "");
        ComponentInputDescriptor descriptor = new ComponentInputDescriptor();
        descriptor.setDescription(description);
        descriptor.setPayload(inputPayload);
        return descriptor;
    }

    private List<String> getInputPayload(AnnotationInfo annotationInfo) {
        Object[] payload = ScannerUtils.parameterValueFrom(annotationInfo, "payload", EMPTY);
        return Arrays.stream(payload).map(annotationClassRef -> ((AnnotationClassRef)annotationClassRef).getName()).collect(Collectors.toList());
    }
}

