/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.reedelk.module.descriptor.analyzer.commons;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;

public class AssetUtils {
    private static final String COMPONENT_IMAGE_NAME_TEMPLATE = "%s.png";
    private static final String COMPONENT_ICON_NAME_TEMPLATE = "%s-icon.png";
    private static final Logger LOG = Logger.getLogger(AssetUtils.class);

    private AssetUtils() {
    }

    public static Image loadImageFromBaseDirectory(String baseDirectory, String componentFullyQualifiedName) {
        try {
            Path baseDirPath = Paths.get(new URI(baseDirectory));
            Path path = Paths.get(baseDirPath.toString(), AssetUtils.imageNameFrom(componentFullyQualifiedName));
            return AssetUtils.getImage(path.toUri().toURL());
        }
        catch (MalformedURLException | URISyntaxException e) {
            return null;
        }
    }

    public static Icon loadIconFromBaseDirectory(String baseDirectory, String componentFullyQualifiedName) {
        try {
            Path baseDirPath = Paths.get(new URI(baseDirectory));
            Path path = Paths.get(baseDirPath.toString(), AssetUtils.iconNameFrom(componentFullyQualifiedName));
            return AssetUtils.getIcon(path.toUri().toURL());
        }
        catch (MalformedURLException | URISyntaxException e) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Image loadImage(String jarFile, String componentFullyQualifiedName) {
        String imageName = AssetUtils.imageNameFrom(componentFullyQualifiedName);
        try (JarFile file = new JarFile(jarFile);){
            ZipEntry componentImage = file.getEntry(imageName);
            if (componentImage != null) {
                try (InputStream inputStream = file.getInputStream(componentImage);){
                    BufferedImage bufferedImage = ImageIO.read(inputStream);
                    return bufferedImage;
                }
            }
            Image image = null;
            return image;
        }
        catch (FileNotFoundException fileNotFoundException) {
            LOG.info((Object)String.format("Component Image named=[%s] from jar file=[%s] could not be found. Using default instead.", imageName, jarFile));
            return null;
        }
        catch (IOException e) {
            LOG.error((Object)e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Icon loadIcon(String jarFile, String componentFullyQualifiedName) {
        String iconName = AssetUtils.iconNameFrom(componentFullyQualifiedName);
        try (JarFile file = new JarFile(jarFile);){
            ZipEntry componentIcon = file.getEntry(iconName);
            if (componentIcon != null) {
                try (InputStream inputStream = file.getInputStream(componentIcon);){
                    ImageIcon imageIcon = new ImageIcon(ImageIO.read(inputStream));
                    return imageIcon;
                }
            }
            Icon icon = null;
            return icon;
        }
        catch (FileNotFoundException fileNotFoundException) {
            LOG.info((Object)String.format("Component Icon named=[%s] from jar file=[%s] could not be found. Using default instead.", iconName, jarFile));
            return null;
        }
        catch (IOException e) {
            LOG.error((Object)e);
            return null;
        }
    }

    public static Icon getIcon(URL iconURL) {
        Icon icon;
        block10: {
            if (iconURL == null) {
                return null;
            }
            InputStream is = iconURL.openStream();
            try {
                icon = AssetUtils.getIcon(is);
                if (is == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    LOG.info((Object)String.format("Component Icon from URL=[%s] could not be found. Using default instead.", iconURL.toString()));
                    return null;
                }
                catch (IOException exception) {
                    LOG.error((Object)exception);
                    return null;
                }
            }
            is.close();
        }
        return icon;
    }

    public static Image getImage(URL imageURL) {
        Image image;
        block10: {
            if (imageURL == null) {
                return null;
            }
            InputStream is = imageURL.openStream();
            try {
                image = AssetUtils.getImage(is);
                if (is == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    LOG.info((Object)String.format("Component Image from URL=[%s] could not be found. Using default instead.", imageURL.toString()));
                    return null;
                }
                catch (IOException e) {
                    LOG.error((Object)e);
                    return null;
                }
            }
            is.close();
        }
        return image;
    }

    private static Image getImage(InputStream inputStream) throws IOException {
        return ImageIO.read(inputStream);
    }

    private static Icon getIcon(InputStream inputStream) throws IOException {
        return new ImageIcon(ImageIO.read(inputStream));
    }

    private static String imageNameFrom(String componentFullyQualifiedName) {
        return String.format(COMPONENT_IMAGE_NAME_TEMPLATE, componentFullyQualifiedName);
    }

    private static String iconNameFrom(String componentFullyQualifiedName) {
        return String.format(COMPONENT_ICON_NAME_TEMPLATE, componentFullyQualifiedName);
    }
}

