/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.reedelk.module.descriptor.analyzer;

import de.codecentric.reedelk.module.descriptor.ModuleDescriptorException;
import de.codecentric.reedelk.module.descriptor.analyzer.commons.AssetUtils;
import de.codecentric.reedelk.module.descriptor.analyzer.commons.Messages;
import de.codecentric.reedelk.module.descriptor.analyzer.commons.ReadModuleDescriptor;
import de.codecentric.reedelk.module.descriptor.analyzer.commons.ScannerUtils;
import de.codecentric.reedelk.module.descriptor.analyzer.component.ComponentAnalyzer;
import de.codecentric.reedelk.module.descriptor.analyzer.component.ComponentAnalyzerFactory;
import de.codecentric.reedelk.module.descriptor.analyzer.type.TypeAnalyzer;
import de.codecentric.reedelk.module.descriptor.json.JsonProvider;
import de.codecentric.reedelk.module.descriptor.model.ModuleDescriptor;
import de.codecentric.reedelk.module.descriptor.model.component.ComponentDescriptor;
import de.codecentric.reedelk.module.descriptor.model.component.ComponentType;
import de.codecentric.reedelk.module.descriptor.model.type.TypeDescriptor;
import de.codecentric.reedelk.runtime.api.RuntimeApi;
import de.codecentric.reedelk.runtime.api.annotation.Description;
import de.codecentric.reedelk.runtime.api.annotation.Module;
import de.codecentric.reedelk.runtime.api.annotation.ModuleComponent;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.ScanResult;
import java.awt.Image;
import java.net.URL;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.swing.Icon;

public class ModuleDescriptorAnalyzer {
    public Optional<ModuleDescriptor> from(String targetJarPath) {
        return ReadModuleDescriptor.from(targetJarPath).map(json -> {
            try {
                ModuleDescriptor moduleDescriptor = JsonProvider.fromJson(json);
                moduleDescriptor.getComponents().forEach(componentDescriptor -> {
                    Icon componentIcon = AssetUtils.loadIcon(targetJarPath, componentDescriptor.getFullyQualifiedName());
                    componentDescriptor.setIcon(componentIcon);
                    Image componentImage = AssetUtils.loadImage(targetJarPath, componentDescriptor.getFullyQualifiedName());
                    componentDescriptor.setImage(componentImage);
                });
                return moduleDescriptor;
            }
            catch (ModuleDescriptorException exception) {
                throw exception;
            }
            catch (Exception exception) {
                String error = Messages.Analyzer.ERROR_FROM_JAR_PATH.format(new Object[]{targetJarPath, exception.getMessage()});
                throw new ModuleDescriptorException(error, exception);
            }
        });
    }

    public ModuleDescriptor fromDirectory(String directory, String moduleName, boolean resolveImages) {
        try {
            ScanResult scanResult = ModuleDescriptorAnalyzer.instantiateScanner().overrideClasspath(directory).scan();
            ModuleDescriptor moduleDescriptor = this.analyzeFrom(scanResult, moduleName);
            if (resolveImages) {
                moduleDescriptor.getComponents().forEach(componentDescriptor -> {
                    String componentFullyQualifiedName = componentDescriptor.getFullyQualifiedName();
                    componentDescriptor.setImage(AssetUtils.loadImageFromBaseDirectory(directory, componentFullyQualifiedName));
                    componentDescriptor.setIcon(AssetUtils.loadIconFromBaseDirectory(directory, componentFullyQualifiedName));
                });
            }
            return moduleDescriptor;
        }
        catch (ModuleDescriptorException exception) {
            throw exception;
        }
        catch (Exception exception) {
            String error = Messages.Analyzer.ERROR_FROM_DIRECTORY.format(new Object[]{directory, moduleName, resolveImages, exception.getMessage()});
            throw new ModuleDescriptorException(error, exception);
        }
    }

    public ModuleDescriptor from(Class<?> systemComponentClazz) {
        URL resource = systemComponentClazz.getClassLoader().getResource("module-descriptor.json");
        ModuleDescriptor moduleDescriptor = JsonProvider.fromURL(resource);
        moduleDescriptor.getComponents().forEach(componentDescriptor -> {
            URL iconURL = systemComponentClazz.getClassLoader().getResource(componentDescriptor.getFullyQualifiedName() + "-icon.png");
            componentDescriptor.setIcon(AssetUtils.getIcon(iconURL));
            URL imageURL = systemComponentClazz.getClassLoader().getResource(componentDescriptor.getFullyQualifiedName() + ".png");
            componentDescriptor.setImage(AssetUtils.getImage(imageURL));
        });
        return moduleDescriptor;
    }

    public List<TypeDescriptor> scanRuntimeApiTypes() {
        try {
            ScanResult scanResult = ModuleDescriptorAnalyzer.instantiateScanner().whitelistPackages(new String[]{RuntimeApi.class.getPackage().getName()}).scan();
            return this.moduleTypesOf(scanResult);
        }
        catch (ModuleDescriptorException exception) {
            throw exception;
        }
        catch (Exception exception) {
            String error = Messages.Analyzer.ERROR_SCAN_API_TYPES.format(new Object[]{exception.getMessage()});
            throw new ModuleDescriptorException(error, exception);
        }
    }

    private ModuleDescriptor analyzeFrom(ScanResult scanResult, String moduleName) {
        String moduleDisplayName = this.moduleDisplayNameOf(scanResult, moduleName);
        String moduleDescription = this.moduleDescriptionOf(scanResult);
        Boolean isBuiltIn = this.moduleIsBuiltInOf(scanResult);
        List<ComponentDescriptor> components = this.moduleComponentsOf(scanResult);
        List<TypeDescriptor> types = this.moduleTypesOf(scanResult);
        ModuleDescriptor moduleDescriptor = new ModuleDescriptor();
        moduleDescriptor.setDisplayName(moduleDisplayName);
        moduleDescriptor.setDescription(moduleDescription);
        moduleDescriptor.setComponents(components);
        moduleDescriptor.setBuiltIn(isBuiltIn);
        moduleDescriptor.setName(moduleName);
        moduleDescriptor.setTypes(types);
        return moduleDescriptor;
    }

    private List<ComponentDescriptor> moduleComponentsOf(ScanResult scanResult) {
        ClassInfoList classInfoList = scanResult.getClassesWithAnnotation(ModuleComponent.class.getName());
        return classInfoList.stream().map(classInfo -> {
            try {
                ComponentAnalyzer componentAnalyzer = ComponentAnalyzerFactory.get(scanResult);
                return componentAnalyzer.analyze((ClassInfo)classInfo);
            }
            catch (Exception exception) {
                String message = Messages.Scan.ERROR_SCAN_COMPONENT.format(new Object[]{classInfo.getName(), exception.getMessage()});
                throw new ModuleDescriptorException(message, exception);
            }
        }).filter(descriptor -> !ComponentType.UNKNOWN.equals((Object)descriptor.getType())).collect(Collectors.toList());
    }

    private List<TypeDescriptor> moduleTypesOf(ScanResult scanResult) {
        TypeAnalyzer analyzer = new TypeAnalyzer(scanResult);
        return analyzer.analyze();
    }

    private Boolean moduleIsBuiltInOf(ScanResult scanResult) {
        ClassInfoList classInfoList = scanResult.getClassesWithAnnotation(Module.class.getName());
        return classInfoList.stream().findFirst().map(classInfo -> ScannerUtils.annotationParameterValueFrom(classInfo, Module.class, "builtIn", null)).orElse(null);
    }

    private String moduleDisplayNameOf(ScanResult scanResult, String moduleName) {
        ClassInfoList classInfoList = scanResult.getClassesWithAnnotation(Module.class.getName());
        return classInfoList.stream().findFirst().map(classInfo -> ScannerUtils.annotationValueFrom(classInfo, Module.class, moduleName)).orElse(moduleName);
    }

    private String moduleDescriptionOf(ScanResult scanResult) {
        ClassInfoList classInfoList = scanResult.getClassesWithAnnotation(Module.class.getName());
        return classInfoList.stream().findFirst().map(classInfo -> ScannerUtils.annotationValueFrom(classInfo, Description.class, null)).orElse(null);
    }

    private static ClassGraph instantiateScanner() {
        return new ClassGraph().enableFieldInfo().enableMethodInfo().enableAnnotationInfo().ignoreFieldVisibility();
    }
}

