/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.reedelk.database.internal.ddlexecute;

import de.codecentric.reedelk.database.component.DDLExecute;
import de.codecentric.reedelk.database.internal.commons.Messages;
import de.codecentric.reedelk.database.internal.ddlexecute.AbstractExecutionStrategy;
import de.codecentric.reedelk.database.internal.exception.DDLExecuteException;
import de.codecentric.reedelk.runtime.api.commons.ComponentPrecondition;
import de.codecentric.reedelk.runtime.api.flow.FlowContext;
import de.codecentric.reedelk.runtime.api.message.Message;
import de.codecentric.reedelk.runtime.api.script.ScriptEngineService;
import de.codecentric.reedelk.runtime.api.script.dynamicvalue.DynamicString;
import de.codecentric.reedelk.runtime.api.script.dynamicvalue.DynamicValue;
import javax.sql.DataSource;

class ExecutionStrategyInline
extends AbstractExecutionStrategy {
    private final DynamicString ddlDefinition;
    private final ScriptEngineService scriptEngine;

    ExecutionStrategyInline(DataSource dataSource, DynamicString ddlDefinition, ScriptEngineService scriptEngine) {
        super(dataSource);
        ComponentPrecondition.Configuration.requireNotNull(DDLExecute.class, (DynamicValue)ddlDefinition, (String)"DDL definition string must be defined for DDL execute component.");
        ComponentPrecondition.Configuration.requireNotBlank(DDLExecute.class, (String)((String)ddlDefinition.value()), (String)"DDL definition string must not empty for DDL execute component.");
        this.ddlDefinition = ddlDefinition;
        this.scriptEngine = scriptEngine;
    }

    @Override
    String ddl(FlowContext flowContext, Message message) {
        return (String)this.scriptEngine.evaluate((DynamicValue)this.ddlDefinition, flowContext, message).orElseThrow(() -> new DDLExecuteException(Messages.DDLExecute.DDL_SCRIPT_EVALUATE_ERROR.format(new Object[]{this.ddlDefinition.value()})));
    }
}

