/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.reedelk.database.internal.ddlexecute;

import de.codecentric.reedelk.database.internal.ddlexecute.DDLDefinitionStrategy;
import de.codecentric.reedelk.database.internal.ddlexecute.ExecutionStrategy;
import de.codecentric.reedelk.database.internal.ddlexecute.ExecutionStrategyFromFile;
import de.codecentric.reedelk.database.internal.ddlexecute.ExecutionStrategyInline;
import de.codecentric.reedelk.runtime.api.resource.ResourceText;
import de.codecentric.reedelk.runtime.api.script.ScriptEngineService;
import de.codecentric.reedelk.runtime.api.script.dynamicvalue.DynamicString;
import javax.sql.DataSource;

public class ExecutionStrategyBuilder {
    private DDLDefinitionStrategy strategy;
    private DynamicString ddlDefinition;
    private ResourceText ddlFile;
    private DataSource dataSource;
    private ScriptEngineService scriptEngine;

    private ExecutionStrategyBuilder() {
    }

    public static ExecutionStrategyBuilder get() {
        return new ExecutionStrategyBuilder();
    }

    public ExecutionStrategyBuilder with(ResourceText ddlFile) {
        this.ddlFile = ddlFile;
        return this;
    }

    public ExecutionStrategyBuilder with(DataSource dataSource) {
        this.dataSource = dataSource;
        return this;
    }

    public ExecutionStrategyBuilder with(DynamicString ddlDefinition) {
        this.ddlDefinition = ddlDefinition;
        return this;
    }

    public ExecutionStrategyBuilder with(DDLDefinitionStrategy strategy) {
        this.strategy = strategy;
        return this;
    }

    public ExecutionStrategyBuilder with(ScriptEngineService scriptEngine) {
        this.scriptEngine = scriptEngine;
        return this;
    }

    public ExecutionStrategy build() {
        if (DDLDefinitionStrategy.INLINE.equals((Object)this.strategy)) {
            return new ExecutionStrategyInline(this.dataSource, this.ddlDefinition, this.scriptEngine);
        }
        if (DDLDefinitionStrategy.FROM_FILE.equals((Object)this.strategy)) {
            return new ExecutionStrategyFromFile(this.dataSource, this.ddlFile);
        }
        throw new IllegalStateException("Execution strategy=[%s] not supported.");
    }
}

