/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.reedelk.database.internal.ddlexecute;

import de.codecentric.reedelk.database.component.DDLExecute;
import de.codecentric.reedelk.database.internal.attribute.DDLExecuteAttributes;
import de.codecentric.reedelk.database.internal.commons.DatabaseUtils;
import de.codecentric.reedelk.database.internal.commons.Messages;
import de.codecentric.reedelk.database.internal.ddlexecute.ExecutionStrategy;
import de.codecentric.reedelk.database.internal.exception.DDLExecuteException;
import de.codecentric.reedelk.runtime.api.commons.StackTraceUtils;
import de.codecentric.reedelk.runtime.api.flow.FlowContext;
import de.codecentric.reedelk.runtime.api.message.Message;
import de.codecentric.reedelk.runtime.api.message.MessageAttributes;
import de.codecentric.reedelk.runtime.api.message.MessageBuilder;
import java.sql.Connection;
import java.sql.Statement;
import java.util.Optional;
import javax.sql.DataSource;

abstract class AbstractExecutionStrategy
implements ExecutionStrategy {
    private final DataSource dataSource;

    AbstractExecutionStrategy(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public Message execute(FlowContext flowContext, Message message) {
        Message message2;
        Connection connection = null;
        Statement statement = null;
        AutoCloseable resultSet = null;
        String ddlToExecute = null;
        try {
            connection = this.dataSource.getConnection();
            statement = connection.createStatement();
            ddlToExecute = this.ddl(flowContext, message);
            int rowCount = statement.executeUpdate(ddlToExecute);
            DDLExecuteAttributes attributes = new DDLExecuteAttributes(ddlToExecute);
            message2 = MessageBuilder.get(DDLExecute.class).withJavaObject((Object)rowCount).attributes((MessageAttributes)attributes).build();
        }
        catch (Throwable exception) {
            try {
                String error = Optional.ofNullable(ddlToExecute).map(ddl -> Messages.DDLExecute.DDL_EXECUTE_ERROR_WITH_DDL.format(new Object[]{ddl, StackTraceUtils.rootCauseMessageOf((Throwable)exception)})).orElse(Messages.DDLExecute.DDL_EXECUTE_ERROR.format(new Object[]{StackTraceUtils.rootCauseMessageOf((Throwable)exception)}));
                throw new DDLExecuteException(error, exception);
            }
            catch (Throwable throwable) {
                DatabaseUtils.closeSilently(resultSet);
                DatabaseUtils.closeSilently(statement);
                DatabaseUtils.closeSilently(connection);
                throw throwable;
            }
        }
        DatabaseUtils.closeSilently(resultSet);
        DatabaseUtils.closeSilently(statement);
        DatabaseUtils.closeSilently(connection);
        return message2;
    }

    abstract String ddl(FlowContext var1, Message var2);
}

