/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.reedelk.database.internal.commons;

import de.codecentric.reedelk.runtime.api.exception.PlatformException;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MetadataUtils {
    private MetadataUtils() {
    }

    public static List<Integer> getColumnType(ResultSetMetaData metadata) {
        ArrayList<Integer> columnTypes = new ArrayList<Integer>();
        try {
            for (int i = 0; i < metadata.getColumnCount(); ++i) {
                columnTypes.add(metadata.getColumnType(i + 1));
            }
            return columnTypes;
        }
        catch (SQLException exception) {
            throw new PlatformException((Throwable)exception);
        }
    }

    public static Map<String, Integer> getColumnNameIndexMap(ResultSetMetaData metadata) {
        HashMap<String, Integer> columnNameIndexMap = new HashMap<String, Integer>();
        try {
            for (int i = 0; i < metadata.getColumnCount(); ++i) {
                columnNameIndexMap.put(metadata.getColumnName(i + 1), i);
            }
            return columnNameIndexMap;
        }
        catch (SQLException exception) {
            throw new PlatformException((Throwable)exception);
        }
    }

    public static Map<Integer, String> getColumnIndexNameMap(ResultSetMetaData metadata) {
        HashMap<Integer, String> columnIndexNameMap = new HashMap<Integer, String>();
        try {
            for (int i = 0; i < metadata.getColumnCount(); ++i) {
                columnIndexNameMap.put(i, metadata.getColumnName(i + 1));
            }
            return columnIndexNameMap;
        }
        catch (SQLException exception) {
            throw new PlatformException((Throwable)exception);
        }
    }
}

