/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.reedelk.database.internal.commons;

import de.codecentric.reedelk.database.internal.commons.Messages;
import de.codecentric.reedelk.database.internal.exception.ConversionError;
import de.codecentric.reedelk.database.internal.type.DatabaseRow;
import de.codecentric.reedelk.runtime.api.commons.ByteArrayUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;

public class DatabaseRowConverter {
    public static DatabaseRow convert(ResultSetMetaData metaData, ResultSet resultSetRow, Map<String, Integer> columnNameIndexMap, Map<Integer, String> columnIndexNameMap) throws SQLException {
        int columnCount = metaData.getColumnCount();
        ArrayList<Serializable> values = new ArrayList<Serializable>();
        for (int i = 1; i <= columnCount; ++i) {
            Serializable rowValue = DatabaseRowConverter.getObjectByColumnId(metaData, i, resultSetRow);
            values.add(rowValue);
        }
        return new DatabaseRow(columnNameIndexMap, columnIndexNameMap, values);
    }

    private static Serializable getObjectByColumnId(ResultSetMetaData metaData, int columnId, ResultSet row) throws SQLException {
        int columnType = metaData.getColumnType(columnId);
        if (columnType == 1) {
            return row.getString(columnId);
        }
        if (columnType == 12) {
            return row.getString(columnId);
        }
        if (columnType == -16) {
            return row.getString(columnId);
        }
        if (columnType == 2) {
            return row.getBigDecimal(columnId);
        }
        if (columnType == 3) {
            return row.getBigDecimal(columnId);
        }
        if (columnType == -7) {
            return Boolean.valueOf(row.getBoolean(columnId));
        }
        if (columnType == -6) {
            return Byte.valueOf(row.getByte(columnId));
        }
        if (columnType == 5) {
            return Short.valueOf(row.getShort(columnId));
        }
        if (columnType == 4) {
            return Integer.valueOf(row.getInt(columnId));
        }
        if (columnType == -5) {
            return Long.valueOf(row.getLong(columnId));
        }
        if (columnType == 7) {
            return Float.valueOf(row.getFloat(columnId));
        }
        if (columnType == 6) {
            return Double.valueOf(row.getDouble(columnId));
        }
        if (columnType == 8) {
            return Double.valueOf(row.getDouble(columnId));
        }
        if (columnType == -2) {
            return row.getBytes(columnId);
        }
        if (columnType == -3) {
            return row.getBytes(columnId);
        }
        if (columnType == -4) {
            return row.getBytes(columnId);
        }
        if (columnType == 91) {
            return row.getDate(columnId);
        }
        if (columnType == 92) {
            return row.getTime(columnId);
        }
        if (columnType == 93) {
            return row.getTimestamp(columnId);
        }
        if (columnType == 16) {
            return Boolean.valueOf(row.getBoolean(columnId));
        }
        if (columnType == -9) {
            return row.getNString(columnId);
        }
        if (columnType == 2004) {
            byte[] byArray;
            block31: {
                Blob blob = row.getBlob(columnId);
                InputStream inputStream = blob.getBinaryStream();
                try {
                    byArray = ByteArrayUtils.from((InputStream)inputStream);
                    if (inputStream == null) break block31;
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException exception) {
                        String columnName = metaData.getColumnName(columnId);
                        String error = Messages.Select.BLOB_TO_BYTES_ERROR.format(new Object[]{columnName});
                        throw new ConversionError(error, exception);
                    }
                }
                inputStream.close();
            }
            return byArray;
        }
        if (columnType == 2005) {
            Clob clob = row.getClob(columnId);
            return DatabaseRowConverter.clobToString(metaData, columnId, clob);
        }
        String columnName = metaData.getColumnName(columnId);
        String error = Messages.Select.COLUMN_TYPE_NOT_SUPPORTED.format(new Object[]{columnType, columnName});
        throw new ConversionError(error);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static String clobToString(ResultSetMetaData metaData, int columnId, Clob data) throws SQLException {
        StringBuilder sb = new StringBuilder();
        try (Reader reader = data.getCharacterStream();){
            String string;
            try (BufferedReader br = new BufferedReader(reader);){
                int b;
                while (-1 != (b = br.read())) {
                    sb.append((char)b);
                }
                string = sb.toString();
            }
            return string;
        }
        catch (IOException | SQLException exception) {
            String columnName = metaData.getColumnName(columnId);
            String error = Messages.Select.CLOB_TO_STRING_ERROR.format(new Object[]{columnName});
            throw new ConversionError(error);
        }
    }
}

