/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.reedelk.database.internal.commons;

import com.mchange.v2.c3p0.ComboPooledDataSource;
import de.codecentric.reedelk.database.component.ConnectionConfiguration;
import de.codecentric.reedelk.database.component.Select;
import de.codecentric.reedelk.database.internal.commons.DatabaseDriver;
import de.codecentric.reedelk.database.internal.commons.IsDriverAvailable;
import de.codecentric.reedelk.runtime.api.commons.ComponentPrecondition;
import de.codecentric.reedelk.runtime.api.component.Component;
import de.codecentric.reedelk.runtime.api.exception.PlatformException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.osgi.service.component.annotations.ServiceScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@org.osgi.service.component.annotations.Component(service={DataSourceService.class}, scope=ServiceScope.SINGLETON)
public class DataSourceService {
    private static final Logger logger = LoggerFactory.getLogger(DataSourceService.class);
    final Map<String, ComboPooledDataSource> CONFIG_ID_CONNECTION_POOL_MAP = new HashMap<String, ComboPooledDataSource>();
    final Map<String, List<Component>> CONFIG_ID_COMPONENT_MAP = new HashMap<String, List<Component>>();

    public synchronized ComboPooledDataSource getDataSource(Component component, ConnectionConfiguration connectionConfiguration) {
        ComponentPrecondition.Configuration.requireNotNull(Select.class, (Object)connectionConfiguration, (String)"Connection configuration must be available");
        DatabaseDriver databaseDriverClass = connectionConfiguration.getDatabaseDriver();
        ComponentPrecondition.Configuration.requireTrue(component.getClass(), (boolean)IsDriverAvailable.of(databaseDriverClass), (String)String.format("Driver '%s' not found. Make sure that the driver is inside {RUNTIME_HOME}/lib directory.", new Object[]{databaseDriverClass}));
        String configId = connectionConfiguration.getId();
        if (!this.CONFIG_ID_CONNECTION_POOL_MAP.containsKey(configId)) {
            ComboPooledDataSource pooledDataSource = new ComboPooledDataSource();
            try {
                pooledDataSource.setDriverClass(databaseDriverClass.qualifiedName());
            }
            catch (Throwable exception) {
                throw new PlatformException(exception);
            }
            pooledDataSource.setJdbcUrl(connectionConfiguration.getConnectionURL());
            pooledDataSource.setUser(connectionConfiguration.getUsername());
            pooledDataSource.setPassword(connectionConfiguration.getPassword());
            Optional.ofNullable(connectionConfiguration.getMinPoolSize()).ifPresent(arg_0 -> ((ComboPooledDataSource)pooledDataSource).setMinPoolSize(arg_0));
            Optional.ofNullable(connectionConfiguration.getMaxPoolSize()).ifPresent(arg_0 -> ((ComboPooledDataSource)pooledDataSource).setMaxPoolSize(arg_0));
            Optional.ofNullable(connectionConfiguration.getAcquireIncrement()).ifPresent(arg_0 -> ((ComboPooledDataSource)pooledDataSource).setAcquireIncrement(arg_0));
            this.CONFIG_ID_CONNECTION_POOL_MAP.put(configId, pooledDataSource);
        }
        this.addComponentMapping(configId, component);
        return this.CONFIG_ID_CONNECTION_POOL_MAP.get(configId);
    }

    public synchronized void dispose(Component component, ConnectionConfiguration connectionConfiguration) {
        if (this.CONFIG_ID_COMPONENT_MAP.containsKey(connectionConfiguration.getId())) {
            List<Component> components = this.CONFIG_ID_COMPONENT_MAP.get(connectionConfiguration.getId());
            components.remove(component);
            if (components.isEmpty()) {
                this.CONFIG_ID_COMPONENT_MAP.remove(connectionConfiguration.getId());
                ComboPooledDataSource toClose = this.CONFIG_ID_CONNECTION_POOL_MAP.remove(connectionConfiguration.getId());
                this.silentlyClose(toClose);
            }
        }
    }

    public synchronized void dispose() {
        this.CONFIG_ID_CONNECTION_POOL_MAP.forEach((configurationId, comboPooledDataSource) -> this.silentlyClose((ComboPooledDataSource)comboPooledDataSource));
        this.CONFIG_ID_CONNECTION_POOL_MAP.clear();
        this.CONFIG_ID_COMPONENT_MAP.clear();
    }

    void silentlyClose(ComboPooledDataSource toClose) {
        try {
            if (toClose != null) {
                toClose.close();
            }
        }
        catch (Exception exception) {
            logger.warn("Could not close pooled data source", (Throwable)exception);
        }
    }

    private void addComponentMapping(String configId, Component component) {
        if (this.CONFIG_ID_COMPONENT_MAP.containsKey(configId)) {
            this.CONFIG_ID_COMPONENT_MAP.get(configId).add(component);
        } else {
            ArrayList<Component> components = new ArrayList<Component>();
            components.add(component);
            this.CONFIG_ID_COMPONENT_MAP.put(configId, components);
        }
    }
}

