/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.reedelk.database.component;

import com.mchange.v2.c3p0.ComboPooledDataSource;
import de.codecentric.reedelk.database.component.ConnectionConfiguration;
import de.codecentric.reedelk.database.internal.attribute.DatabaseAttributes;
import de.codecentric.reedelk.database.internal.attribute.SelectAttributes;
import de.codecentric.reedelk.database.internal.commons.DataSourceService;
import de.codecentric.reedelk.database.internal.commons.DatabaseRowConverter;
import de.codecentric.reedelk.database.internal.commons.DatabaseUtils;
import de.codecentric.reedelk.database.internal.commons.DisposableResultSet;
import de.codecentric.reedelk.database.internal.commons.Messages;
import de.codecentric.reedelk.database.internal.commons.MetadataUtils;
import de.codecentric.reedelk.database.internal.commons.QueryStatementTemplate;
import de.codecentric.reedelk.database.internal.exception.SelectException;
import de.codecentric.reedelk.database.internal.type.DatabaseRow;
import de.codecentric.reedelk.database.internal.type.ListOfDatabaseRow;
import de.codecentric.reedelk.runtime.api.annotation.ComponentInput;
import de.codecentric.reedelk.runtime.api.annotation.ComponentOutput;
import de.codecentric.reedelk.runtime.api.annotation.Description;
import de.codecentric.reedelk.runtime.api.annotation.DialogTitle;
import de.codecentric.reedelk.runtime.api.annotation.Example;
import de.codecentric.reedelk.runtime.api.annotation.Hint;
import de.codecentric.reedelk.runtime.api.annotation.KeyName;
import de.codecentric.reedelk.runtime.api.annotation.ModuleComponent;
import de.codecentric.reedelk.runtime.api.annotation.Property;
import de.codecentric.reedelk.runtime.api.annotation.TabGroup;
import de.codecentric.reedelk.runtime.api.annotation.ValueName;
import de.codecentric.reedelk.runtime.api.commons.ComponentPrecondition;
import de.codecentric.reedelk.runtime.api.commons.StackTraceUtils;
import de.codecentric.reedelk.runtime.api.component.Component;
import de.codecentric.reedelk.runtime.api.component.ProcessorSync;
import de.codecentric.reedelk.runtime.api.flow.Disposable;
import de.codecentric.reedelk.runtime.api.flow.FlowContext;
import de.codecentric.reedelk.runtime.api.message.Message;
import de.codecentric.reedelk.runtime.api.message.MessageAttributes;
import de.codecentric.reedelk.runtime.api.message.MessageBuilder;
import de.codecentric.reedelk.runtime.api.message.content.TypedPublisher;
import de.codecentric.reedelk.runtime.api.script.ScriptEngineService;
import de.codecentric.reedelk.runtime.api.script.dynamicmap.DynamicMap;
import de.codecentric.reedelk.runtime.api.script.dynamicmap.DynamicObjectMap;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

@ModuleComponent(value="SQL Select")
@ComponentOutput(attributes={DatabaseAttributes.class}, payload={ListOfDatabaseRow.class}, description="A list of database rows.")
@ComponentInput(payload={Object.class}, description="The input payload is used to evaluate the expressions bound to the query parameters mappings.")
@Description(value="Executes a SELECT SQL statement on the configured data source connection. Supported databases and drivers: H2 (org.h2.Driver), MySQL (com.mysql.cj.jdbc.Driver), Oracle (oracle.jdbc.Driver), PostgreSQL (org.postgresql.Driver).")
@org.osgi.service.component.annotations.Component(service={Select.class}, scope=ServiceScope.PROTOTYPE)
public class Select
implements ProcessorSync {
    @DialogTitle(value="Data Source Configuration")
    @Property(value="Connection")
    @Description(value="Data source configuration to be used by this query. Shared configurations use the same connection pool.")
    private ConnectionConfiguration connection;
    @Example(value="<ul><li><code>SELECT * FROM orders WHERE name = 'John' AND surname = 'Doe'</code></li><li><code>SELECT * FROM orders WHERE name LIKE :name AND surname = :surname</code></li></ul>")
    @Property(value="Select Query")
    @Hint(value="SELECT * FROM orders WHERE name LIKE :name")
    @Description(value="The <b>select</b> query to be executed on the database with the given Data Source connection. The query might contain parameters which will be filled from the expressions defined in the parameters mapping configuration. below.")
    private String query;
    @Property(value="Query Parameter Mappings")
    @TabGroup(value="Query Parameter Mappings")
    @KeyName(value="Query Parameter Name")
    @ValueName(value="Query Parameter Value")
    @Example(value="name > <code>message.payload()</code>")
    @Description(value="Mapping of select query parameters > values. Query parameters will be evaluated and replaced each time before the query is executed.")
    private DynamicObjectMap parametersMapping = DynamicObjectMap.empty();
    @Reference
    DataSourceService dataSourceService;
    @Reference
    ScriptEngineService scriptEngine;
    private ComboPooledDataSource dataSource;
    private QueryStatementTemplate queryStatement;

    public void initialize() {
        ComponentPrecondition.Configuration.requireNotBlank(Select.class, (String)this.query, (String)"Select query is not defined");
        this.dataSource = this.dataSourceService.getDataSource((Component)this, this.connection);
        this.queryStatement = new QueryStatementTemplate(this.query);
    }

    public Message apply(FlowContext flowContext, Message message) {
        ResultSetMetaData metaData;
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        String realQuery = null;
        try {
            connection = this.dataSource.getConnection();
            statement = connection.createStatement();
            Map evaluatedMap = this.scriptEngine.evaluate((DynamicMap)this.parametersMapping, flowContext, message);
            realQuery = this.queryStatement.replace(evaluatedMap);
            resultSet = statement.executeQuery(realQuery);
        }
        catch (Throwable exception) {
            DatabaseUtils.closeSilently(resultSet);
            DatabaseUtils.closeSilently(statement);
            DatabaseUtils.closeSilently(connection);
            String error = Optional.ofNullable(realQuery).map(query -> Messages.Select.QUERY_EXECUTE_ERROR_WITH_QUERY.format(new Object[]{query, StackTraceUtils.rootCauseMessageOf((Throwable)exception)})).orElse(Messages.Select.QUERY_EXECUTE_ERROR.format(new Object[]{StackTraceUtils.rootCauseMessageOf((Throwable)exception)}));
            throw new SelectException(error, exception);
        }
        DisposableResultSet disposableResultSet = new DisposableResultSet(connection, statement, resultSet);
        flowContext.register((Disposable)disposableResultSet);
        try {
            metaData = disposableResultSet.getMetaData();
        }
        catch (SQLException exception) {
            String error = Messages.Select.METADATA_FETCH_ERROR.format(new Object[]{exception.getErrorCode(), exception.getSQLState(), exception.getMessage()});
            throw new SelectException(error, exception);
        }
        List<Integer> columnTypes = MetadataUtils.getColumnType(metaData);
        Map<String, Integer> columnNameIndexMap = MetadataUtils.getColumnNameIndexMap(metaData);
        Map<Integer, String> columnIndexNameMap = MetadataUtils.getColumnIndexNameMap(metaData);
        TypedPublisher<DatabaseRow> result = this.createResultStream(metaData, disposableResultSet, columnNameIndexMap, columnIndexNameMap);
        SelectAttributes selectAttributes = new SelectAttributes(this.query, columnTypes);
        return MessageBuilder.get(Select.class).withTypedPublisher(result).attributes((MessageAttributes)selectAttributes).build();
    }

    public void dispose() {
        this.dataSourceService.dispose((Component)this, this.connection);
        this.dataSource = null;
        this.queryStatement = null;
    }

    public void setConnection(ConnectionConfiguration connection) {
        this.connection = connection;
    }

    public void setParametersMapping(DynamicObjectMap parametersMapping) {
        this.parametersMapping = parametersMapping;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    private TypedPublisher<DatabaseRow> createResultStream(ResultSetMetaData metaData, DisposableResultSet disposableResultSet, Map<String, Integer> columnNameIndexMap, Map<Integer, String> columnIndexNameMap) {
        return TypedPublisher.from((Publisher)Flux.create(sink -> {
            try {
                while (disposableResultSet.next()) {
                    DatabaseRow row = DatabaseRowConverter.convert(metaData, disposableResultSet, columnNameIndexMap, columnIndexNameMap);
                    sink.next((Object)row);
                }
                sink.complete();
            }
            catch (Throwable exception) {
                sink.error(exception);
            }
        }), DatabaseRow.class);
    }
}

