/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.reedelk.database.component;

import com.mchange.v2.c3p0.ComboPooledDataSource;
import de.codecentric.reedelk.database.component.ConnectionConfiguration;
import de.codecentric.reedelk.database.component.Insert;
import de.codecentric.reedelk.database.internal.attribute.DatabaseAttributes;
import de.codecentric.reedelk.database.internal.commons.DataSourceService;
import de.codecentric.reedelk.database.internal.commons.DatabaseUtils;
import de.codecentric.reedelk.database.internal.commons.Messages;
import de.codecentric.reedelk.database.internal.commons.QueryStatementTemplate;
import de.codecentric.reedelk.database.internal.exception.DeleteException;
import de.codecentric.reedelk.runtime.api.annotation.ComponentInput;
import de.codecentric.reedelk.runtime.api.annotation.ComponentOutput;
import de.codecentric.reedelk.runtime.api.annotation.Description;
import de.codecentric.reedelk.runtime.api.annotation.DialogTitle;
import de.codecentric.reedelk.runtime.api.annotation.Example;
import de.codecentric.reedelk.runtime.api.annotation.Hint;
import de.codecentric.reedelk.runtime.api.annotation.KeyName;
import de.codecentric.reedelk.runtime.api.annotation.ModuleComponent;
import de.codecentric.reedelk.runtime.api.annotation.Property;
import de.codecentric.reedelk.runtime.api.annotation.TabGroup;
import de.codecentric.reedelk.runtime.api.annotation.ValueName;
import de.codecentric.reedelk.runtime.api.commons.ComponentPrecondition;
import de.codecentric.reedelk.runtime.api.commons.StackTraceUtils;
import de.codecentric.reedelk.runtime.api.component.Component;
import de.codecentric.reedelk.runtime.api.component.ProcessorSync;
import de.codecentric.reedelk.runtime.api.flow.FlowContext;
import de.codecentric.reedelk.runtime.api.message.Message;
import de.codecentric.reedelk.runtime.api.message.MessageAttributes;
import de.codecentric.reedelk.runtime.api.message.MessageBuilder;
import de.codecentric.reedelk.runtime.api.script.ScriptEngineService;
import de.codecentric.reedelk.runtime.api.script.dynamicmap.DynamicMap;
import de.codecentric.reedelk.runtime.api.script.dynamicmap.DynamicObjectMap;
import java.sql.Connection;
import java.sql.Statement;
import java.util.Map;
import java.util.Optional;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@ModuleComponent(value="SQL Delete")
@ComponentOutput(attributes={DatabaseAttributes.class}, payload={int.class}, description="The number of rows deleted from the database.")
@ComponentInput(payload={Object.class}, description="The input payload is used to evaluate the expressions bound to the query parameters mappings.")
@Description(value="Executes a DELETE SQL statement on the configured data source connection. Supported databases and drivers: H2 (org.h2.Driver), MySQL (com.mysql.cj.jdbc.Driver), Oracle (oracle.jdbc.Driver), PostgreSQL (org.postgresql.Driver).")
@org.osgi.service.component.annotations.Component(service={Delete.class}, scope=ServiceScope.PROTOTYPE)
public class Delete
implements ProcessorSync {
    @DialogTitle(value="Data Source Configuration")
    @Property(value="Connection")
    @Description(value="Data source configuration to be used by this query. Shared configurations use the same connection pool.")
    private ConnectionConfiguration connection;
    @Property(value="Delete Query")
    @Example(value="<ul><li>DELETE FROM orders WHERE id = 1</li><li>DELETE FROM orders WHERE name LIKE 'item%'</li><li>DELETE * FROM employees WHERE employee_country = :country</li></ul>")
    @Hint(value="DELETE FROM orders WHERE id = 1")
    @Description(value="The <b>delete</b> query to be executed on the database with the given Data Source connection. The query might contain parameters which will be filled from the expressions defined in the parameters mapping configuration below.")
    private String query;
    @Property(value="Query Parameter Mappings")
    @TabGroup(value="Query Parameter Mappings")
    @KeyName(value="Query Parameter Name")
    @ValueName(value="Query Parameter Value")
    @Example(value="id > <code>message.payload()</code>")
    @Description(value="Mapping of delete query parameters > values. Query parameters will be evaluated and replaced each time before the query is executed.")
    private DynamicObjectMap parametersMapping = DynamicObjectMap.empty();
    @Reference
    DataSourceService dataSourceService;
    @Reference
    ScriptEngineService scriptEngine;
    private QueryStatementTemplate queryStatement;
    private ComboPooledDataSource dataSource;

    public void initialize() {
        ComponentPrecondition.Configuration.requireNotBlank(Insert.class, (String)this.query, (String)"Delete query is not defined");
        this.dataSource = this.dataSourceService.getDataSource((Component)this, this.connection);
        this.queryStatement = new QueryStatementTemplate(this.query);
    }

    public Message apply(FlowContext flowContext, Message message) {
        Message message2;
        Connection connection = null;
        Statement statement = null;
        AutoCloseable resultSet = null;
        String realQuery = null;
        try {
            connection = this.dataSource.getConnection();
            statement = connection.createStatement();
            Map evaluatedMap = this.scriptEngine.evaluate((DynamicMap)this.parametersMapping, flowContext, message);
            realQuery = this.queryStatement.replace(evaluatedMap);
            int rowCount = statement.executeUpdate(realQuery);
            DatabaseAttributes attributes = new DatabaseAttributes(realQuery);
            message2 = MessageBuilder.get(Delete.class).withJavaObject((Object)rowCount).attributes((MessageAttributes)attributes).build();
        }
        catch (Throwable exception) {
            try {
                String error = Optional.ofNullable(realQuery).map(query -> Messages.Delete.QUERY_EXECUTE_ERROR_WITH_QUERY.format(new Object[]{query, StackTraceUtils.rootCauseMessageOf((Throwable)exception)})).orElse(Messages.Delete.QUERY_EXECUTE_ERROR.format(new Object[]{StackTraceUtils.rootCauseMessageOf((Throwable)exception)}));
                throw new DeleteException(error, exception);
            }
            catch (Throwable throwable) {
                DatabaseUtils.closeSilently(resultSet);
                DatabaseUtils.closeSilently(statement);
                DatabaseUtils.closeSilently(connection);
                throw throwable;
            }
        }
        DatabaseUtils.closeSilently(resultSet);
        DatabaseUtils.closeSilently(statement);
        DatabaseUtils.closeSilently(connection);
        return message2;
    }

    public void dispose() {
        this.dataSourceService.dispose((Component)this, this.connection);
        this.dataSource = null;
        this.queryStatement = null;
    }

    public void setParametersMapping(DynamicObjectMap parametersMapping) {
        this.parametersMapping = parametersMapping;
    }

    public void setConnection(ConnectionConfiguration connection) {
        this.connection = connection;
    }

    public void setQuery(String query) {
        this.query = query;
    }
}

