/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.reedelk.database.component;

import de.codecentric.reedelk.database.component.ConnectionConfiguration;
import de.codecentric.reedelk.database.internal.attribute.DDLExecuteAttributes;
import de.codecentric.reedelk.database.internal.commons.DataSourceService;
import de.codecentric.reedelk.database.internal.ddlexecute.DDLDefinitionStrategy;
import de.codecentric.reedelk.database.internal.ddlexecute.ExecutionStrategy;
import de.codecentric.reedelk.database.internal.ddlexecute.ExecutionStrategyBuilder;
import de.codecentric.reedelk.runtime.api.annotation.ComponentInput;
import de.codecentric.reedelk.runtime.api.annotation.ComponentOutput;
import de.codecentric.reedelk.runtime.api.annotation.DefaultValue;
import de.codecentric.reedelk.runtime.api.annotation.Description;
import de.codecentric.reedelk.runtime.api.annotation.DialogTitle;
import de.codecentric.reedelk.runtime.api.annotation.Example;
import de.codecentric.reedelk.runtime.api.annotation.Hint;
import de.codecentric.reedelk.runtime.api.annotation.HintBrowseFile;
import de.codecentric.reedelk.runtime.api.annotation.InitValue;
import de.codecentric.reedelk.runtime.api.annotation.ModuleComponent;
import de.codecentric.reedelk.runtime.api.annotation.Property;
import de.codecentric.reedelk.runtime.api.annotation.When;
import de.codecentric.reedelk.runtime.api.commons.ComponentPrecondition;
import de.codecentric.reedelk.runtime.api.component.Component;
import de.codecentric.reedelk.runtime.api.component.ProcessorSync;
import de.codecentric.reedelk.runtime.api.flow.FlowContext;
import de.codecentric.reedelk.runtime.api.message.Message;
import de.codecentric.reedelk.runtime.api.resource.ResourceText;
import de.codecentric.reedelk.runtime.api.script.ScriptEngineService;
import de.codecentric.reedelk.runtime.api.script.dynamicvalue.DynamicString;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@ModuleComponent(value="DDL Execute")
@ComponentOutput(attributes={DDLExecuteAttributes.class}, payload={int.class}, description="Either the row count for SQL Data Manipulation Language (DML) statements or 0 for SQL statements that return nothing")
@ComponentInput(payload={Object.class}, description="The input payload is not used by this component. The DDL statements are executed from the given inline definition or resource file.")
@Description(value="Executes the given DDL statement/s on the configured data source connection. This component can be used to create/drop/alter/rename database tables. Supported databases and drivers: H2 (org.h2.Driver), MySQL (com.mysql.cj.jdbc.Driver), Oracle (oracle.jdbc.Driver), PostgreSQL (org.postgresql.Driver). The database drivers libraries must be present in the <b>{RUNTIME_HOME}/lib</b> directory.")
@org.osgi.service.component.annotations.Component(service={DDLExecute.class}, scope=ServiceScope.PROTOTYPE)
public class DDLExecute
implements ProcessorSync {
    @DialogTitle(value="Data Source Configuration")
    @Property(value="Connection")
    @Description(value="Data source configuration where the DDL statements will be executed on. Shared configurations use the same connection pool.")
    private ConnectionConfiguration connection;
    @Property(value="Strategy")
    @InitValue(value="INLINE")
    @Example(value="FROM_FILE")
    @DefaultValue(value="INLINE")
    @Description(value="Execution strategy for this DDL. If <b>INLINE</b> then a static or dynamic inline statement is executed from the given <i>ddlDefinition</i> property, otherwise if <b>FROM_FILE</b> DDL statements are executed from the given <i>ddlFile</i> local project's file.")
    private DDLDefinitionStrategy strategy;
    @Property(value="DDL Definition")
    @Example(value="<ul><li><code>CREATE TABLE person (id INT, name VARCHAR(255), surname VARCHAR(255), address VARCHAR(255), city VARCHAR(255))</code></li><li><code>DROP TABLE person</code></li></ul>")
    @Hint(value="CREATE TABLE person (id INT, name VARCHAR(255), surname VARCHAR(255), address VARCHAR(255), city VARCHAR(255))")
    @When(propertyName="strategy", propertyValue="INLINE")
    @Description(value="Sets the DDL definition to be executed by this component. The DDL definition might be a static or dynamic value.")
    private DynamicString ddlDefinition;
    @Property(value="DDL File")
    @HintBrowseFile(value="Select DDL File ...")
    @Example(value="assets/create_table_company.sql")
    @When(propertyName="strategy", propertyValue="FROM_FILE")
    @Description(value="Sets the file path in the project's resources directory containing the DDL statements to be executed when the strategy is <b>FROM_FILE</b>.")
    private ResourceText ddlFile;
    @Reference
    DataSourceService dataSourceService;
    @Reference
    ScriptEngineService scriptEngine;
    private ExecutionStrategy executionStrategy;
    private DataSource dataSource;

    public void initialize() {
        ComponentPrecondition.Configuration.requireNotNull(DDLExecute.class, (Object)this.connection, (String)"Connection configuration must be defined.");
        this.dataSource = this.dataSourceService.getDataSource((Component)this, this.connection);
        this.executionStrategy = ExecutionStrategyBuilder.get().with(this.strategy).with(this.ddlFile).with(this.dataSource).with(this.ddlDefinition).with(this.scriptEngine).build();
    }

    public Message apply(FlowContext flowContext, Message message) {
        return this.executionStrategy.execute(flowContext, message);
    }

    public void dispose() {
        this.dataSourceService.dispose((Component)this, this.connection);
        this.ddlFile = null;
        this.dataSource = null;
        this.ddlDefinition = null;
    }

    public void setConnection(ConnectionConfiguration connection) {
        this.connection = connection;
    }

    public void setStrategy(DDLDefinitionStrategy strategy) {
        this.strategy = strategy;
    }

    public void setDdlDefinition(DynamicString ddlDefinition) {
        this.ddlDefinition = ddlDefinition;
    }

    public void setDdlFile(ResourceText ddlFile) {
        this.ddlFile = ddlFile;
    }
}

