/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.reedelk.database.component;

import de.codecentric.reedelk.database.internal.commons.DatabaseDriver;
import de.codecentric.reedelk.runtime.api.annotation.DefaultValue;
import de.codecentric.reedelk.runtime.api.annotation.Description;
import de.codecentric.reedelk.runtime.api.annotation.Example;
import de.codecentric.reedelk.runtime.api.annotation.Hidden;
import de.codecentric.reedelk.runtime.api.annotation.Hint;
import de.codecentric.reedelk.runtime.api.annotation.InitValue;
import de.codecentric.reedelk.runtime.api.annotation.Password;
import de.codecentric.reedelk.runtime.api.annotation.Property;
import de.codecentric.reedelk.runtime.api.annotation.Shared;
import de.codecentric.reedelk.runtime.api.component.Implementor;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ServiceScope;

@Shared
@Component(service={ConnectionConfiguration.class}, scope=ServiceScope.PROTOTYPE)
public class ConnectionConfiguration
implements Implementor {
    @Property(value="id")
    @Hidden
    private String id;
    @Property(value="Connection URL")
    @Example(value="<ul><li>H2: jdbc:h2:~/test</li><li>MySQL: jdbc:mysql://localhost:3306/mydatabase</li><li>Oracle: jdbc:oracle:thin:@localhost:1521:orcl</li><li>PostgreSQL: jdbc:postgresql://host:port/database</li></ul>")
    @Hint(value="jdbc:mysql://localhost:3306/mydatabase")
    @InitValue(value="jdbc:mysql://localhost:3306/mydatabase")
    @Description(value="The connection URL is a string that a JDBC driver uses to connect to a database. It can contain information such as where to search for the database, the name of the database to connect to, and configuration properties.")
    private String connectionURL;
    @Property(value="Username")
    @Hint(value="myDatabaseUser")
    @Example(value="myDatabaseUser")
    @Description(value="The username to be used to create the database connection.")
    private String username;
    @Property(value="Password")
    @Password
    @Example(value="myDatabasePassword")
    @Description(value="The password to be used to create the database connection.")
    private String password;
    @Example(value="ORACLE")
    @InitValue(value="MYSQL")
    @Property(value="Driver")
    @Description(value="The fully qualified name of the JDBC database driver class. The JDBC drivers must be present in the {RUNTIME_HOME}/lib directory.")
    private DatabaseDriver databaseDriver;
    @Property(value="Min Pool Size")
    @Hint(value="3")
    @Example(value="5")
    @DefaultValue(value="3")
    @Description(value="Minimum number of Connections the connection pool will maintain at any given time.")
    private Integer minPoolSize;
    @Property(value="Max Pool Size")
    @Hint(value="15")
    @Example(value="20")
    @DefaultValue(value="15")
    @Description(value="Maximum number of Connections the connection pool will maintain at any given time.")
    private Integer maxPoolSize;
    @Property(value="Acquire Increment")
    @Hint(value="3")
    @Example(value="5")
    @DefaultValue(value="3")
    @Description(value="Determines how many connections at a time the connection pool will try to acquire when the pool is exhausted.")
    private Integer acquireIncrement;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getConnectionURL() {
        return this.connectionURL;
    }

    public void setConnectionURL(String connectionURL) {
        this.connectionURL = connectionURL;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public DatabaseDriver getDatabaseDriver() {
        return this.databaseDriver;
    }

    public void setDatabaseDriver(DatabaseDriver databaseDriver) {
        this.databaseDriver = databaseDriver;
    }

    public Integer getMinPoolSize() {
        return this.minPoolSize;
    }

    public void setMinPoolSize(Integer minPoolSize) {
        this.minPoolSize = minPoolSize;
    }

    public Integer getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(Integer maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public Integer getAcquireIncrement() {
        return this.acquireIncrement;
    }

    public void setAcquireIncrement(Integer acquireIncrement) {
        this.acquireIncrement = acquireIncrement;
    }
}

