/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.reedelk.core.component;

import de.codecentric.reedelk.runtime.api.annotation.ComponentInput;
import de.codecentric.reedelk.runtime.api.annotation.ComponentOutput;
import de.codecentric.reedelk.runtime.api.annotation.DefaultValue;
import de.codecentric.reedelk.runtime.api.annotation.Description;
import de.codecentric.reedelk.runtime.api.annotation.Example;
import de.codecentric.reedelk.runtime.api.annotation.Hint;
import de.codecentric.reedelk.runtime.api.annotation.InitValue;
import de.codecentric.reedelk.runtime.api.annotation.MimeTypeCombo;
import de.codecentric.reedelk.runtime.api.annotation.ModuleComponent;
import de.codecentric.reedelk.runtime.api.annotation.Property;
import de.codecentric.reedelk.runtime.api.commons.ComponentPrecondition;
import de.codecentric.reedelk.runtime.api.component.ProcessorSync;
import de.codecentric.reedelk.runtime.api.flow.FlowContext;
import de.codecentric.reedelk.runtime.api.message.Message;
import de.codecentric.reedelk.runtime.api.message.content.MimeType;
import de.codecentric.reedelk.runtime.api.script.ScriptEngineService;
import de.codecentric.reedelk.runtime.api.script.dynamicvalue.DynamicObject;
import de.codecentric.reedelk.runtime.api.script.dynamicvalue.DynamicValue;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@ModuleComponent(value="Variable Set")
@ComponentOutput(attributes={ComponentOutput.PreviousComponent.class}, payload={ComponentOutput.PreviousComponent.class})
@ComponentInput(payload={Object.class}, description="Any input. The input message is used to evaluate the dynamic expression whose result is assigned to the context variable with the given name.")
@Description(value="Sets a variable in the flow context with the provided value.")
@Component(service={VariableSet.class}, scope=ServiceScope.PROTOTYPE)
public class VariableSet
implements ProcessorSync {
    @Property(value="Name")
    @Hint(value="mySampleVariable")
    @Example(value="mySampleVariable")
    @Description(value="The name of the variable to be set in the flow context.")
    private String name;
    @Property(value="Mime type")
    @MimeTypeCombo
    @DefaultValue(value="*/*")
    @Example(value="application/json")
    @Description(value="The mime type of the value this context variable will be bound to.")
    private String mimeType;
    @Property(value="Value")
    @Hint(value="my variable content")
    @InitValue(value="#[message.payload()]")
    @Example(value="<code>message.attributes().pathParams</code>")
    @Description(value="The value to assign to the context variable being set. It might be a static or dynamic value.")
    private DynamicObject value;
    @Reference
    private ScriptEngineService scriptEngine;

    public void initialize() {
        ComponentPrecondition.Configuration.requireNotBlank(VariableSet.class, (String)this.name, (String)"Variable name to set must not be empty");
    }

    public Message apply(FlowContext flowContext, Message message) {
        MimeType mimeType = MimeType.parse((String)this.mimeType, (MimeType)MimeType.ANY);
        Object result = this.scriptEngine.evaluate((DynamicValue)this.value, mimeType, flowContext, message).orElse(null);
        flowContext.put((Object)this.name, result);
        return message;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setValue(DynamicObject value) {
        this.value = value;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }
}

