/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.reedelk.core.component;

import de.codecentric.reedelk.runtime.api.annotation.ComponentInput;
import de.codecentric.reedelk.runtime.api.annotation.ComponentOutput;
import de.codecentric.reedelk.runtime.api.annotation.Description;
import de.codecentric.reedelk.runtime.api.annotation.Example;
import de.codecentric.reedelk.runtime.api.annotation.Hint;
import de.codecentric.reedelk.runtime.api.annotation.ModuleComponent;
import de.codecentric.reedelk.runtime.api.annotation.Property;
import de.codecentric.reedelk.runtime.api.commons.ComponentPrecondition;
import de.codecentric.reedelk.runtime.api.component.ProcessorSync;
import de.codecentric.reedelk.runtime.api.flow.FlowContext;
import de.codecentric.reedelk.runtime.api.message.Message;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ServiceScope;

@ModuleComponent(value="Variable Remove")
@ComponentOutput(attributes={ComponentOutput.PreviousComponent.class}, payload={ComponentOutput.PreviousComponent.class})
@ComponentInput(payload={Object.class}, description="Any input. The input message is not used by this component.")
@Description(value="Removes a variable previously set in the flow context.")
@Component(service={VariableRemove.class}, scope=ServiceScope.PROTOTYPE)
public class VariableRemove
implements ProcessorSync {
    @Property(value="Name")
    @Hint(value="mySampleVariable")
    @Example(value="mySampleVariable")
    @Description(value="The name of the variable to be removed from the flow context.")
    private String name;

    public void initialize() {
        ComponentPrecondition.Configuration.requireNotBlank(VariableRemove.class, (String)this.name, (String)"Variable name to remove must not be empty");
    }

    public Message apply(FlowContext flowContext, Message message) {
        flowContext.remove((Object)this.name);
        return message;
    }

    public void setName(String name) {
        this.name = name;
    }
}

