/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.reedelk.core.component;

import de.codecentric.reedelk.runtime.api.annotation.ComponentInput;
import de.codecentric.reedelk.runtime.api.annotation.ComponentOutput;
import de.codecentric.reedelk.runtime.api.annotation.Description;
import de.codecentric.reedelk.runtime.api.annotation.Example;
import de.codecentric.reedelk.runtime.api.annotation.Hint;
import de.codecentric.reedelk.runtime.api.annotation.InitValue;
import de.codecentric.reedelk.runtime.api.annotation.ModuleComponent;
import de.codecentric.reedelk.runtime.api.annotation.Property;
import de.codecentric.reedelk.runtime.api.commons.StringUtils;
import de.codecentric.reedelk.runtime.api.component.ProcessorSync;
import de.codecentric.reedelk.runtime.api.converter.ConverterService;
import de.codecentric.reedelk.runtime.api.flow.FlowContext;
import de.codecentric.reedelk.runtime.api.message.Message;
import de.codecentric.reedelk.runtime.api.message.MessageBuilder;
import de.codecentric.reedelk.runtime.api.message.content.TypedContent;
import de.codecentric.reedelk.runtime.api.type.ListOfString;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@ModuleComponent(value="Split Text")
@ComponentOutput(attributes={ComponentOutput.PreviousComponent.class}, payload={ListOfString.class}, description="A list containing the segments of the input payload split using the delimiter.")
@ComponentInput(payload={String.class}, description="Any payload input string to be split using the delimiter. If the input is not a string, it is first converted to string using the default system charset.")
@Description(value="The Split Text component splits the text from the Message payload using the provided delimiter or regular expression. A collection containing all the strings computed by splitting the message payload with the delimiter.")
@Component(service={SplitText.class}, scope=ServiceScope.PROTOTYPE)
public class SplitText
implements ProcessorSync {
    @Property(value="Delimiter")
    @Hint(value=",")
    @Example(value=";")
    @InitValue(value=",")
    @Description(value="The delimiter to be used to split the message payload. A regular expression can be used.")
    private String delimiter;
    @Reference
    private ConverterService converterService;

    public Message apply(FlowContext flowContext, Message message) {
        Object segments;
        TypedContent content = message.content();
        if (content == null) {
            return MessageBuilder.get(SplitText.class).withList(Collections.emptyList(), String.class).attributes(message.attributes()).build();
        }
        String payloadAsString = (String)this.converterService.convert(content.data(), String.class);
        if (StringUtils.isBlank((CharSequence)payloadAsString)) {
            segments = new ListOfString();
        } else {
            String[] split = payloadAsString.split(this.delimiter);
            segments = Arrays.asList(split);
        }
        return MessageBuilder.get(SplitText.class).withList((List)segments, String.class).attributes(message.attributes()).build();
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public String getDelimiter() {
        return this.delimiter;
    }
}

