/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.reedelk.core.component;

import de.codecentric.reedelk.runtime.api.annotation.ComponentInput;
import de.codecentric.reedelk.runtime.api.annotation.ComponentOutput;
import de.codecentric.reedelk.runtime.api.annotation.DefaultValue;
import de.codecentric.reedelk.runtime.api.annotation.Description;
import de.codecentric.reedelk.runtime.api.annotation.Example;
import de.codecentric.reedelk.runtime.api.annotation.Group;
import de.codecentric.reedelk.runtime.api.annotation.Hint;
import de.codecentric.reedelk.runtime.api.annotation.MimeTypeCombo;
import de.codecentric.reedelk.runtime.api.annotation.ModuleComponent;
import de.codecentric.reedelk.runtime.api.annotation.Property;
import de.codecentric.reedelk.runtime.api.commons.DynamicValueUtils;
import de.codecentric.reedelk.runtime.api.component.ProcessorSync;
import de.codecentric.reedelk.runtime.api.flow.FlowContext;
import de.codecentric.reedelk.runtime.api.message.Message;
import de.codecentric.reedelk.runtime.api.message.MessageBuilder;
import de.codecentric.reedelk.runtime.api.message.content.MimeType;
import de.codecentric.reedelk.runtime.api.script.Script;
import de.codecentric.reedelk.runtime.api.script.ScriptEngineService;
import de.codecentric.reedelk.runtime.api.script.dynamicvalue.DynamicString;
import de.codecentric.reedelk.runtime.api.script.dynamicvalue.DynamicValue;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@ModuleComponent(value="Script")
@ComponentInput(payload={Object.class}, description="The message data to be evaluated by this script")
@ComponentOutput(attributes={ComponentOutput.PreviousComponent.class}, payload={Object.class}, description="The result of the evaluated script")
@Description(value="Executes the given script function and sets the result of its evaluation in the payload content. The script function must be defined in a file with .groovy extension in the project's <i>resources/scripts</i> folder. The function must have the following signature:<br><br><pre><code> fun myFunctionName(context, message) {<br>   // Function code<br>   'my result'<br> }<br></code></pre><br>The <i>context</i> variable can be used to access data stored in the flow context and the <i>message</i> variable is the current flow message object. To access the message content from the script use <code>message.payload()</code>.")
@Component(service={ScriptEvaluator.class}, scope=ServiceScope.PROTOTYPE)
public class ScriptEvaluator
implements ProcessorSync {
    @Property(value="Mime type")
    @MimeTypeCombo
    @Example(value="text/xml")
    @DefaultValue(value="text/plain")
    @Description(value="Sets the mime type of the script result in the message payload; e.g: if the result of the script is JSON, then <i>application/json</i> should be selected.This is useful to let the following components in the flow know how to process the message payload set by this script. For instance, the REST listener would use this information to set the correct content type in the request's response body.")
    private String mimeType;
    @Property(value="Script")
    @Example(value="mapJsonModel.groovy")
    @Description(value="Sets the script file to be executed by this component. Must be a file path and name starting from the project's resources/scripts directory.")
    private Script script;
    @Property(value="Target Variable")
    @Hint(value="myScriptResult")
    @Example(value="myScriptResult")
    @Group(value="Advanced")
    @Description(value="If the property is not empty, the result of the script evaluation is assigned to the given context variable instead of the message payload.")
    private DynamicString target;
    @Reference
    private ScriptEngineService service;

    public Message apply(FlowContext flowContext, Message message) {
        MimeType mimeType = MimeType.parse((String)this.mimeType, (MimeType)MimeType.TEXT_PLAIN);
        Object evaluated = this.service.evaluate(this.script, Object.class, new Object[]{flowContext, message}).orElse(null);
        if (DynamicValueUtils.isNotNullOrBlank((DynamicValue)this.target)) {
            this.service.evaluate((DynamicValue)this.target, flowContext, message).ifPresent(contextVariableName -> flowContext.put(contextVariableName, evaluated));
            return message;
        }
        return MessageBuilder.get(ScriptEvaluator.class).withJavaObject(evaluated, mimeType).attributes(message.attributes()).build();
    }

    public void setTarget(DynamicString target) {
        this.target = target;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public void setScript(Script script) {
        this.script = script;
    }

    public DynamicString getTarget() {
        return this.target;
    }
}

