/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.reedelk.core.component;

import de.codecentric.reedelk.core.internal.attribute.ResourceReadAttributes;
import de.codecentric.reedelk.runtime.api.annotation.ComponentInput;
import de.codecentric.reedelk.runtime.api.annotation.ComponentOutput;
import de.codecentric.reedelk.runtime.api.annotation.DefaultValue;
import de.codecentric.reedelk.runtime.api.annotation.Description;
import de.codecentric.reedelk.runtime.api.annotation.Example;
import de.codecentric.reedelk.runtime.api.annotation.Hint;
import de.codecentric.reedelk.runtime.api.annotation.HintBrowseFile;
import de.codecentric.reedelk.runtime.api.annotation.InitValue;
import de.codecentric.reedelk.runtime.api.annotation.Mandatory;
import de.codecentric.reedelk.runtime.api.annotation.MimeTypeCombo;
import de.codecentric.reedelk.runtime.api.annotation.ModuleComponent;
import de.codecentric.reedelk.runtime.api.annotation.Property;
import de.codecentric.reedelk.runtime.api.annotation.When;
import de.codecentric.reedelk.runtime.api.annotation.Whens;
import de.codecentric.reedelk.runtime.api.commons.ComponentPrecondition;
import de.codecentric.reedelk.runtime.api.commons.MimeTypeUtils;
import de.codecentric.reedelk.runtime.api.component.ProcessorSync;
import de.codecentric.reedelk.runtime.api.flow.FlowContext;
import de.codecentric.reedelk.runtime.api.message.Message;
import de.codecentric.reedelk.runtime.api.message.MessageAttributes;
import de.codecentric.reedelk.runtime.api.message.MessageBuilder;
import de.codecentric.reedelk.runtime.api.message.content.MimeType;
import de.codecentric.reedelk.runtime.api.resource.ResourceText;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ServiceScope;
import org.reactivestreams.Publisher;

@ModuleComponent(value="Resource Read Text")
@ComponentInput(payload={Object.class}, description="The input payload is not used by this component. The resource is read from the given Resource File path property.")
@ComponentOutput(attributes={ResourceReadAttributes.class}, payload={String.class}, description="The content of the resource file read from the project's resources folder.")
@Description(value="Reads a file from the project's resources folder and sets its content into the flow message. The type of the message payload is string. This component might be used to load text files (e.g .txt, .json, .xml) from the project's resources folder. The Mime Type property assign the mime type of the file to the message payload. If Auto Mime Type is selected, the mime type is automatically determined from the file extension.")
@Component(service={ResourceReadText.class}, scope=ServiceScope.PROTOTYPE)
public class ResourceReadText
implements ProcessorSync {
    @Mandatory
    @Property(value="Resource file")
    @Hint(value="assets/sample.txt")
    @Example(value="assets/data_model.json")
    @HintBrowseFile(value="Select Resource Text File ...")
    @Description(value="The path and name of the file to be read from the project's resources folder.")
    private ResourceText resourceFile;
    @Property(value="Auto mime type")
    @Example(value="true")
    @InitValue(value="true")
    @DefaultValue(value="false")
    @Description(value="If true, the mime type of the payload is determined from the extension of the resource read.")
    private boolean autoMimeType;
    @Property(value="Mime type")
    @MimeTypeCombo
    @Example(value="application/json")
    @DefaultValue(value="text/plain")
    @Whens(value={@When(propertyName="autoMimeType", propertyValue="false"), @When(propertyName="autoMimeType", propertyValue="###BLANK###")})
    @Description(value="The mime type of the resource read from local project's resources directory.")
    private String mimeType;

    public void initialize() {
        ComponentPrecondition.Configuration.requireNotNull(ResourceReadText.class, (Object)this.resourceFile, (String)"resource file must be set");
    }

    public Message apply(FlowContext flowContext, Message message) {
        Publisher data = this.resourceFile.data();
        String resourceFilePath = this.resourceFile.path();
        MimeType mimeType = MimeTypeUtils.fromFileExtensionOrParse((boolean)this.autoMimeType, (String)resourceFilePath, (String)this.mimeType, (MimeType)MimeType.TEXT_PLAIN);
        ResourceReadAttributes attributes = new ResourceReadAttributes(resourceFilePath);
        return MessageBuilder.get(ResourceReadText.class).attributes((MessageAttributes)attributes).withString(data, mimeType).build();
    }

    public void setResourceFile(ResourceText resourceFile) {
        this.resourceFile = resourceFile;
    }

    public void setAutoMimeType(boolean autoMimeType) {
        this.autoMimeType = autoMimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }
}

