/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.reedelk.core.component;

import de.codecentric.reedelk.core.component.ResourceReadDynamicConfiguration;
import de.codecentric.reedelk.core.internal.attribute.ResourceReadAttributes;
import de.codecentric.reedelk.runtime.api.annotation.ComponentInput;
import de.codecentric.reedelk.runtime.api.annotation.ComponentOutput;
import de.codecentric.reedelk.runtime.api.annotation.DefaultValue;
import de.codecentric.reedelk.runtime.api.annotation.Description;
import de.codecentric.reedelk.runtime.api.annotation.Example;
import de.codecentric.reedelk.runtime.api.annotation.Group;
import de.codecentric.reedelk.runtime.api.annotation.Hint;
import de.codecentric.reedelk.runtime.api.annotation.InitValue;
import de.codecentric.reedelk.runtime.api.annotation.Mandatory;
import de.codecentric.reedelk.runtime.api.annotation.MimeTypeCombo;
import de.codecentric.reedelk.runtime.api.annotation.ModuleComponent;
import de.codecentric.reedelk.runtime.api.annotation.Property;
import de.codecentric.reedelk.runtime.api.annotation.When;
import de.codecentric.reedelk.runtime.api.annotation.Whens;
import de.codecentric.reedelk.runtime.api.commons.ComponentPrecondition;
import de.codecentric.reedelk.runtime.api.commons.MimeTypeUtils;
import de.codecentric.reedelk.runtime.api.component.ProcessorSync;
import de.codecentric.reedelk.runtime.api.converter.ConverterService;
import de.codecentric.reedelk.runtime.api.exception.PlatformException;
import de.codecentric.reedelk.runtime.api.flow.FlowContext;
import de.codecentric.reedelk.runtime.api.message.Message;
import de.codecentric.reedelk.runtime.api.message.MessageAttributes;
import de.codecentric.reedelk.runtime.api.message.MessageBuilder;
import de.codecentric.reedelk.runtime.api.message.content.MimeType;
import de.codecentric.reedelk.runtime.api.message.content.TypedPublisher;
import de.codecentric.reedelk.runtime.api.resource.DynamicResource;
import de.codecentric.reedelk.runtime.api.resource.ResourceFile;
import de.codecentric.reedelk.runtime.api.resource.ResourceNotFound;
import de.codecentric.reedelk.runtime.api.resource.ResourceService;
import de.codecentric.reedelk.runtime.api.script.dynamicvalue.DynamicValue;
import java.util.Optional;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;
import org.reactivestreams.Publisher;

@ModuleComponent(value="Resource Read Dynamic")
@ComponentInput(payload={Object.class}, description="The input payload is not used by this component. The resource is read from the given Resource File path property.")
@ComponentOutput(attributes={ResourceReadAttributes.class}, payload={byte[].class, String.class}, description="The content of the resource file read from the project's resources folder. The output is string if the mime type is a string based type e.g text/plain, otherwise a byte array.")
@Description(value="Reads a file from the project's resources folder and sets its content into the flow message. The type of the message payload is byte array. The Mime Type property assign the mime type of the file to the message payload. If Auto Mime Type is selected, the mime type is automatically determined from the file extension. This component allows to specify the path and file name of the resource with a dynamic value instead of a static one. This component might be used to load binary data (e.g a picture file) from the project's resources folder in a dynamic fashion: for instance loading files from a given REST Listener request path's value.")
@Component(service={ResourceReadDynamic.class}, scope=ServiceScope.PROTOTYPE)
public class ResourceReadDynamic
implements ProcessorSync {
    @Mandatory
    @Property(value="Resource file")
    @Hint(value="/assets/sample.jpg")
    @InitValue(value="#['/assets/sample.jpg']")
    @Example(value="<code>message.attributes().get('pathParams').filePathParam</code>")
    @Description(value="The path and name of the file to be read from the project's resources folder. The value which might be static or a dynamic expression must point to a file existing in the project's resources directory")
    private DynamicResource resourceFile;
    @Property(value="Auto mime type")
    @Example(value="true")
    @InitValue(value="true")
    @DefaultValue(value="false")
    @Description(value="If true, the mime type of the payload is determined from the extension of the resource read.")
    private boolean autoMimeType;
    @Property(value="Mime type")
    @MimeTypeCombo
    @Example(value="image/jpeg")
    @DefaultValue(value="application/octet-stream")
    @Whens(value={@When(propertyName="autoMimeType", propertyValue="false"), @When(propertyName="autoMimeType", propertyValue="###BLANK###")})
    @Description(value="The mime type of the resource read from local project's resources directory.")
    private String mimeType;
    @Group(value="Configuration")
    @Property(value="Configuration")
    private ResourceReadDynamicConfiguration configuration;
    @Reference
    ResourceService resourceService;
    @Reference
    ConverterService converterService;
    private int readBufferSize;

    public void initialize() {
        ComponentPrecondition.Configuration.requireNotNullOrBlank(ResourceReadDynamic.class, (DynamicValue)this.resourceFile, (String)"resource file expression must not be null or empty");
        this.readBufferSize = Optional.ofNullable(this.configuration).flatMap(resourceReadDynamicConfiguration -> Optional.ofNullable(resourceReadDynamicConfiguration.getReadBufferSize())).orElse(65536);
    }

    public Message apply(FlowContext flowContext, Message message) {
        try {
            ResourceFile resourceFile = this.resourceService.find(this.resourceFile, this.readBufferSize, flowContext, message);
            String resourceFilePath = resourceFile.path();
            Publisher dataStream = resourceFile.data();
            ResourceReadAttributes attributes = new ResourceReadAttributes(resourceFilePath);
            MimeType actualMimeType = MimeTypeUtils.fromFileExtensionOrParse((boolean)this.autoMimeType, (String)resourceFilePath, (String)this.mimeType, (MimeType)MimeType.APPLICATION_BINARY);
            if (String.class == actualMimeType.javaType()) {
                TypedPublisher streamAsString = this.converterService.convert(TypedPublisher.fromByteArray((Publisher)dataStream), String.class);
                return MessageBuilder.get(ResourceReadDynamic.class).withString((Publisher)streamAsString, actualMimeType).attributes((MessageAttributes)attributes).build();
            }
            return MessageBuilder.get(ResourceReadDynamic.class).withBinary(dataStream, actualMimeType).attributes((MessageAttributes)attributes).build();
        }
        catch (ResourceNotFound resourceNotFound) {
            throw new PlatformException((Throwable)resourceNotFound);
        }
    }

    public void setResourceFile(DynamicResource resourceFile) {
        this.resourceFile = resourceFile;
    }

    public void setAutoMimeType(boolean autoMimeType) {
        this.autoMimeType = autoMimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public void setConfiguration(ResourceReadDynamicConfiguration configuration) {
        this.configuration = configuration;
    }
}

