/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.reedelk.core.component;

import de.codecentric.reedelk.core.internal.attribute.ResourceReadAttributes;
import de.codecentric.reedelk.runtime.api.annotation.ComponentInput;
import de.codecentric.reedelk.runtime.api.annotation.ComponentOutput;
import de.codecentric.reedelk.runtime.api.annotation.DefaultValue;
import de.codecentric.reedelk.runtime.api.annotation.Description;
import de.codecentric.reedelk.runtime.api.annotation.Example;
import de.codecentric.reedelk.runtime.api.annotation.HintBrowseFile;
import de.codecentric.reedelk.runtime.api.annotation.InitValue;
import de.codecentric.reedelk.runtime.api.annotation.Mandatory;
import de.codecentric.reedelk.runtime.api.annotation.MimeTypeCombo;
import de.codecentric.reedelk.runtime.api.annotation.ModuleComponent;
import de.codecentric.reedelk.runtime.api.annotation.Property;
import de.codecentric.reedelk.runtime.api.annotation.When;
import de.codecentric.reedelk.runtime.api.annotation.Whens;
import de.codecentric.reedelk.runtime.api.commons.ComponentPrecondition;
import de.codecentric.reedelk.runtime.api.commons.MimeTypeUtils;
import de.codecentric.reedelk.runtime.api.component.ProcessorSync;
import de.codecentric.reedelk.runtime.api.converter.ConverterService;
import de.codecentric.reedelk.runtime.api.flow.FlowContext;
import de.codecentric.reedelk.runtime.api.message.Message;
import de.codecentric.reedelk.runtime.api.message.MessageAttributes;
import de.codecentric.reedelk.runtime.api.message.MessageBuilder;
import de.codecentric.reedelk.runtime.api.message.content.MimeType;
import de.codecentric.reedelk.runtime.api.resource.ResourceBinary;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;
import org.reactivestreams.Publisher;

@ModuleComponent(value="Resource Read Binary")
@ComponentInput(payload={Object.class}, description="The input payload is not used by this component. The resource is read from the given Resource File path property.")
@ComponentOutput(attributes={ResourceReadAttributes.class}, payload={byte[].class}, description="The content of the resource file read from the project's resources folder.")
@Description(value="Reads a file from the project's resources folder and sets its content into the flow message. The type of the message payload is byte array. This component might be used to load binary data (e.g a picture file) from the project's resources folder. The Mime Type property assign the mime type of the file to the message payload. If Auto Mime Type is selected, the mime type is automatically determined from the file extension.")
@Component(service={ResourceReadBinary.class}, scope=ServiceScope.PROTOTYPE)
public class ResourceReadBinary
implements ProcessorSync {
    @Mandatory
    @Property(value="Resource file")
    @Example(value="assets/my_image.jpg")
    @HintBrowseFile(value="Select Resource Binary File ...")
    @Description(value="The path and name of the file to be read from the project's resources folder.")
    private ResourceBinary resourceFile;
    @Property(value="Auto mime type")
    @Example(value="true")
    @InitValue(value="true")
    @DefaultValue(value="false")
    @Description(value="If true, the mime type of the payload is determined from the extension of the resource read.")
    private boolean autoMimeType;
    @Property(value="Mime type")
    @MimeTypeCombo
    @Example(value="image/jpeg")
    @DefaultValue(value="application/octet-stream")
    @Whens(value={@When(propertyName="autoMimeType", propertyValue="false"), @When(propertyName="autoMimeType", propertyValue="###BLANK###")})
    @Description(value="The mime type of the resource read from local project's resources directory.")
    private String mimeType;
    @Reference
    ConverterService converterService;

    public void initialize() {
        ComponentPrecondition.Configuration.requireNotNull(ResourceReadBinary.class, (Object)this.resourceFile, (String)"resource file must be set");
    }

    public Message apply(FlowContext flowContext, Message message) {
        Publisher data = this.resourceFile.data();
        String resourceFilePath = this.resourceFile.path();
        ResourceReadAttributes attributes = new ResourceReadAttributes(resourceFilePath);
        MimeType mimeType = MimeTypeUtils.fromFileExtensionOrParse((boolean)this.autoMimeType, (String)resourceFilePath, (String)this.mimeType, (MimeType)MimeType.APPLICATION_BINARY);
        return MessageBuilder.get(ResourceReadBinary.class).withBinary(data, mimeType).attributes((MessageAttributes)attributes).build();
    }

    public void setResourceFile(ResourceBinary resourceFile) {
        this.resourceFile = resourceFile;
    }

    public void setAutoMimeType(boolean autoMimeType) {
        this.autoMimeType = autoMimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }
}

