/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.reedelk.core.component;

import de.codecentric.reedelk.runtime.api.annotation.ComponentInput;
import de.codecentric.reedelk.runtime.api.annotation.ComponentOutput;
import de.codecentric.reedelk.runtime.api.annotation.DefaultValue;
import de.codecentric.reedelk.runtime.api.annotation.Description;
import de.codecentric.reedelk.runtime.api.annotation.Example;
import de.codecentric.reedelk.runtime.api.annotation.MimeTypeCombo;
import de.codecentric.reedelk.runtime.api.annotation.ModuleComponent;
import de.codecentric.reedelk.runtime.api.annotation.Property;
import de.codecentric.reedelk.runtime.api.component.ProcessorSync;
import de.codecentric.reedelk.runtime.api.converter.ConverterService;
import de.codecentric.reedelk.runtime.api.flow.FlowContext;
import de.codecentric.reedelk.runtime.api.message.Message;
import de.codecentric.reedelk.runtime.api.message.MessageBuilder;
import de.codecentric.reedelk.runtime.api.message.content.MimeType;
import de.codecentric.reedelk.runtime.api.message.content.TypedContent;
import de.codecentric.reedelk.runtime.api.message.content.TypedPublisher;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@ModuleComponent(value="Payload To String")
@ComponentOutput(attributes={ComponentOutput.PreviousComponent.class}, payload={String.class}, description="Converts the payload to a string")
@ComponentInput(payload={Object.class}, description="Any payload input to be converted to a string")
@Description(value="Transforms the message payload to string type. This component can be used when the payload is a byte array or a byte array stream and we want to convert it to a string for further processing. This might be necessary for instance when the result of a REST Call does not have a mime type assigned. In this case the result will be a byte array and in order to further process the content with a script we must convert it to a string type.")
@Component(service={PayloadToString.class}, scope=ServiceScope.PROTOTYPE)
public class PayloadToString
implements ProcessorSync {
    @Property(value="Mime Type")
    @MimeTypeCombo
    @DefaultValue(value="text/plain")
    @Example(value="application/json")
    @Description(value="Sets the new mime type of the payload content.")
    private String mimeType;
    @Reference
    private ConverterService converterService;
    private MimeType wantedMimeType;

    public void initialize() {
        this.wantedMimeType = MimeType.parse((String)this.mimeType, (MimeType)MimeType.TEXT_PLAIN);
    }

    public Message apply(FlowContext flowContext, Message message) {
        TypedContent content = message.content();
        if (content.isStream()) {
            TypedPublisher stream = content.stream();
            TypedPublisher output = this.converterService.convert(stream, String.class);
            return MessageBuilder.get(PayloadToString.class).withTypedPublisher(output, this.wantedMimeType).attributes(message.attributes()).build();
        }
        Object data = content.data();
        String converted = (String)this.converterService.convert(data, String.class);
        return MessageBuilder.get(PayloadToString.class).withString(converted, this.wantedMimeType).attributes(message.attributes()).build();
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }
}

