/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.reedelk.core.component;

import de.codecentric.reedelk.runtime.api.annotation.ComponentInput;
import de.codecentric.reedelk.runtime.api.annotation.ComponentOutput;
import de.codecentric.reedelk.runtime.api.annotation.DefaultValue;
import de.codecentric.reedelk.runtime.api.annotation.Description;
import de.codecentric.reedelk.runtime.api.annotation.Example;
import de.codecentric.reedelk.runtime.api.annotation.Hint;
import de.codecentric.reedelk.runtime.api.annotation.InitValue;
import de.codecentric.reedelk.runtime.api.annotation.MimeTypeCombo;
import de.codecentric.reedelk.runtime.api.annotation.ModuleComponent;
import de.codecentric.reedelk.runtime.api.annotation.Property;
import de.codecentric.reedelk.runtime.api.component.ProcessorSync;
import de.codecentric.reedelk.runtime.api.flow.FlowContext;
import de.codecentric.reedelk.runtime.api.message.Message;
import de.codecentric.reedelk.runtime.api.message.MessageBuilder;
import de.codecentric.reedelk.runtime.api.message.content.MimeType;
import de.codecentric.reedelk.runtime.api.script.ScriptEngineService;
import de.codecentric.reedelk.runtime.api.script.dynamicvalue.DynamicObject;
import de.codecentric.reedelk.runtime.api.script.dynamicvalue.DynamicValue;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@ModuleComponent(value="Payload Set")
@ComponentOutput(attributes={ComponentOutput.PreviousComponent.class}, payload={ComponentOutput.InferFromDynamicProperty.class}, dynamicPropertyName="payload", description="Sets the new message payload by evaluating the expression. The attributes are not changed.")
@ComponentInput(payload={Object.class}, description="Any payload input to be evaluated")
@Description(value="Sets the content of the current message payload to the given payload value. The payload value could be a static text value or a dynamic expression. The mime type specifies the type of the new payload value.")
@Component(service={PayloadSet.class}, scope=ServiceScope.PROTOTYPE)
public class PayloadSet
implements ProcessorSync {
    @Property(value="Mime type")
    @MimeTypeCombo
    @Example(value="application/json")
    @DefaultValue(value="*/*")
    @Description(value="Sets the mime type of the new payload being set.")
    private String mimeType;
    @Property(value="Payload")
    @Hint(value="Payload text")
    @InitValue(value="#[message.payload()]")
    @Example(value="<code>Json.stringify([ data: message.attributes().pathParams.name, id: Util.uuid() ])</code>")
    @Description(value="The new payload to be set to the current flow message.")
    private DynamicObject payload;
    @Reference
    private ScriptEngineService scriptEngine;

    public Message apply(FlowContext flowContext, Message message) {
        MimeType parsedMimeType = MimeType.parse((String)this.mimeType, (MimeType)MimeType.ANY);
        Object result = this.scriptEngine.evaluate((DynamicValue)this.payload, parsedMimeType, flowContext, message).orElse(null);
        return MessageBuilder.get(PayloadSet.class).withJavaObject(result, parsedMimeType).attributes(message.attributes()).build();
    }

    public void setPayload(DynamicObject payload) {
        this.payload = payload;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }
}

